/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker.strategy;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.location.Location;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.strategy.AbstractDockerPlacementStrategy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuUsagePlacementStrategy
extends AbstractDockerPlacementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CpuUsagePlacementStrategy.class);
    public static final ConfigKey<Double> DOCKER_CONTAINER_CLUSTER_MAX_CPU = ConfigKeys.newDoubleConfigKey((String)"docker.container.cluster.maxCpu", (String)"Maximum CPU usage across a Docker container cluster", (Double)0.5);

    @Override
    protected List<Location> getDockerHostLocations(Multimap<Location, Entity> members, List<DockerHostLocation> available, int n) {
        ArrayList chosen = Lists.newArrayList();
        for (DockerHostLocation machine : ImmutableList.copyOf(available)) {
            Double maxCpu = (Double)machine.getOwner().getConfig(DOCKER_CONTAINER_CLUSTER_MAX_CPU);
            Double currentCpu = (Double)machine.getOwner().getAttribute(DockerHost.CPU_USAGE);
            if (!(currentCpu < maxCpu)) continue;
            chosen.add(machine);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Available Docker hosts: {}", (Object)Iterables.toString((Iterable)chosen));
        }
        if (chosen.isEmpty()) {
            Collection added = this.getDockerInfrastructure().getDockerHostCluster().resizeByDelta(1);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added Docker host: {}", (Object)Iterables.toString((Iterable)added));
            }
            DockerHost host = (DockerHost)Iterables.getOnlyElement((Iterable)added);
            Entities.waitForServiceUp((Entity)host);
            chosen.add(host.getDynamicLocation());
        }
        ImmutableList result = ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)chosen), (int)n));
        return result;
    }
}

