/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker.strategy;

import brooklyn.entity.Entity;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.group.zoneaware.BalancingNodePlacementStrategy;
import brooklyn.entity.trait.Identifiable;
import brooklyn.location.Location;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.strategy.DockerAwarePlacementStrategy;
import brooklyn.util.collections.MutableList;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class AbstractDockerPlacementStrategy
extends BalancingNodePlacementStrategy
implements DockerAwarePlacementStrategy {
    private static final Function<Identifiable, String> identity = new Function<Identifiable, String>(){

        public String apply(@Nullable Identifiable input) {
            return input.getClass().getSimpleName() + ":" + input.getId();
        }
    };
    protected DockerInfrastructure infrastructure;

    public static final Function<Identifiable, String> identity() {
        return identity;
    }

    @Override
    public void init(List<DockerHostLocation> locations) {
        DockerHostLocation first = (DockerHostLocation)Iterables.get(locations, (int)0);
        this.infrastructure = first.getDockerInfrastructure();
    }

    public final List<Location> locationsForAdditions(Multimap<Location, Entity> members, Collection<? extends Location> locations, int n) {
        if (locations.isEmpty() && n > 0) {
            throw new IllegalArgumentException("No locations supplied, when requesting locations for " + n + " nodes");
        }
        if (n <= 0) {
            return Lists.newArrayList();
        }
        MutableList available = MutableList.copyOf((Iterable)Iterables.filter(locations, DockerHostLocation.class));
        this.init((List<DockerHostLocation>)available);
        return this.getDockerHostLocations(members, (List<DockerHostLocation>)available, n);
    }

    protected abstract List<Location> getDockerHostLocations(Multimap<Location, Entity> var1, List<DockerHostLocation> var2, int var3);

    @Override
    public DockerInfrastructure getDockerInfrastructure() {
        return this.infrastructure;
    }

    @Override
    public Map<DockerHostLocation, Integer> toAvailableLocationSizes(Iterable<DockerHostLocation> locations) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (DockerHostLocation host : locations) {
            result.put(host, host.getCurrentSize());
        }
        return result;
    }

    public String toString() {
        return String.format("DockerAwarePlacementStrategy(%s)", this.getClass().getSimpleName());
    }
}

