/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.location.Location;
import brooklyn.location.MachineLocation;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.NoMachinesAvailableException;
import brooklyn.location.affinity.AffinityRuleExtension;
import brooklyn.location.affinity.DockerAffinityRuleStrategy;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.cloud.AvailabilityZoneExtension;
import brooklyn.location.docker.DockerContainerLocation;
import brooklyn.location.docker.DockerHostExtension;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.DockerVirtualLocation;
import brooklyn.location.docker.strategy.DepthFirstPlacementStrategy;
import brooklyn.location.dynamic.DynamicLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.mutex.MutexSupport;
import brooklyn.util.mutex.WithMutexes;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerLocation
extends AbstractLocation
implements DockerVirtualLocation,
MachineProvisioningLocation<MachineLocation>,
DynamicLocation<DockerInfrastructure, DockerLocation>,
WithMutexes,
Closeable {
    private static final long serialVersionUID = -4562281299895377963L;
    private static final Logger LOG = LoggerFactory.getLogger(DockerLocation.class);
    public static final String DOCKER_HOST_MUTEX = "dockerhost";
    @SetFromFlag(value="mutex")
    private transient WithMutexes mutexSupport;
    @SetFromFlag(value="owner")
    private DockerInfrastructure infrastructure;
    @SetFromFlag(value="strategy")
    private DynamicCluster.NodePlacementStrategy strategy;
    @SetFromFlag(value="provisioner")
    private MachineProvisioningLocation<SshMachineLocation> provisioner;
    private final Multimap<SshMachineLocation, String> machines = HashMultimap.create();
    private final Map<String, DockerHostLocation> containers = Maps.newHashMap();

    public DockerLocation() {
        this(Maps.newLinkedHashMap());
    }

    public DockerLocation(Map properties) {
        super(properties);
        if (this.isLegacyConstruction()) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addExtension(AvailabilityZoneExtension.class, (Object)new DockerHostExtension(this.getManagementContext(), this));
        this.addExtension(AffinityRuleExtension.class, new DockerAffinityRuleStrategy(this.getManagementContext(), this));
        if (this.strategy == null) {
            this.strategy = new DepthFirstPlacementStrategy();
        }
        if (this.mutexSupport == null) {
            this.mutexSupport = new MutexSupport();
        }
    }

    public MachineProvisioningLocation<SshMachineLocation> getProvisioner() {
        return this.provisioner;
    }

    public MachineLocation obtain() throws NoMachinesAvailableException {
        return this.obtain(Maps.newLinkedHashMap());
    }

    public MachineLocation obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
        try {
            Collection added;
            this.acquireMutex(DOCKER_HOST_MUTEX, "Obtaining Docker host");
            Object context = flags.get(LocationConfigKeys.CALLER_CONTEXT.getName());
            if (context != null && !(context instanceof Entity)) {
                throw new IllegalStateException("Invalid location context: " + context);
            }
            Entity entity = (Entity)context;
            List<Location> dockerHosts = ((AffinityRuleExtension)this.getExtension(AffinityRuleExtension.class)).filterLocations(entity);
            DockerHostLocation machine = null;
            DockerHost dockerHost = null;
            if (dockerHosts != null && dockerHosts.size() > 0) {
                added = this.strategy.locationsForAdditions(null, dockerHosts, 1);
                machine = (DockerHostLocation)Iterables.getOnlyElement((Iterable)added);
                dockerHost = machine.getOwner();
            } else {
                added = this.getDockerInfrastructure().getDockerHostCluster().resizeByDelta(1);
                dockerHost = (DockerHost)Iterables.getOnlyElement((Iterable)added);
                machine = (DockerHostLocation)dockerHost.getDynamicLocation();
            }
            Entities.waitForServiceUp((Entity)dockerHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Obtain a new container from {} for {}", (Object)machine, (Object)entity);
            }
            MutableMap hostFlags = MutableMap.copyOf(flags);
            DockerContainerLocation container = machine.obtain((Map<?, ?>)hostFlags);
            this.machines.put((Object)machine.getMachine(), (Object)container.getId());
            this.containers.put(container.getId(), machine);
            DockerContainerLocation dockerContainerLocation = container;
            return dockerContainerLocation;
        }
        catch (InterruptedException ie) {
            throw Exceptions.propagate((Throwable)ie);
        }
        finally {
            this.releaseMutex(DOCKER_HOST_MUTEX);
        }
    }

    public MachineProvisioningLocation<MachineLocation> newSubLocation(Map<?, ?> newFlags) {
        throw new UnsupportedOperationException();
    }

    public void release(MachineLocation machine) {
        block12: {
            if (this.provisioner == null) {
                throw new IllegalStateException("No provisioner available to release " + machine);
            }
            try {
                this.acquireMutex(DOCKER_HOST_MUTEX, "Releasing Docker host " + machine);
                String id = machine.getId();
                DockerHostLocation host = this.containers.remove(id);
                if (host == null) {
                    throw new IllegalArgumentException("Request to release " + machine + ", but this machine is not currently allocated");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request to remove container mapping {} to {}", (Object)host, (Object)id);
                }
                host.release((DockerContainerLocation)machine);
                if (this.machines.remove((Object)host.getMachine(), (Object)id)) {
                    if (this.machines.get((Object)host.getMachine()).isEmpty()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Empty Docker host: {}", (Object)host);
                        }
                        if (((Boolean)this.getOwner().getConfig(DockerInfrastructure.REMOVE_EMPTY_DOCKER_HOSTS)).booleanValue()) {
                            LOG.info("Removing empty Docker host: {}", (Object)host);
                            this.remove(host);
                        }
                    }
                    break block12;
                }
                throw new IllegalArgumentException("Request to release " + machine + ", but container mapping not found");
            }
            catch (InterruptedException ie) {
                throw Exceptions.propagate((Throwable)ie);
            }
            finally {
                this.releaseMutex(DOCKER_HOST_MUTEX);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(DockerHostLocation machine) {
        LOG.info("Releasing {}", (Object)machine);
        DynamicCluster cluster = this.infrastructure.getDockerHostCluster();
        DockerHost host = machine.getOwner();
        if (cluster.removeMember((Entity)host)) {
            LOG.info("Docker Host {} released", (Object)host.getDockerHostName());
        } else {
            LOG.warn("Docker Host {} not found for release", (Object)host.getDockerHostName());
        }
        try {
            machine.close();
            host.stop();
        }
        catch (Exception e) {
            LOG.warn("Error stopping host: " + host, (Throwable)e);
            Exceptions.propagateIfFatal((Throwable)e);
        }
        finally {
            Entities.unmanage((Entity)host);
        }
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        return Maps.newLinkedHashMap();
    }

    public DockerInfrastructure getOwner() {
        return this.infrastructure;
    }

    @Override
    public List<Entity> getDockerContainerList() {
        return this.infrastructure.getDockerContainerList();
    }

    @Override
    public List<Entity> getDockerHostList() {
        return this.infrastructure.getDockerHostList();
    }

    @Override
    public DockerInfrastructure getDockerInfrastructure() {
        return this.infrastructure;
    }

    @Override
    public void close() throws IOException {
        LOG.info("Close called on Docker infrastructure: {}", (Object)this);
    }

    public void acquireMutex(String mutexId, String description) throws InterruptedException {
        this.mutexSupport.acquireMutex(mutexId, description);
    }

    public boolean tryAcquireMutex(String mutexId, String description) {
        return this.mutexSupport.tryAcquireMutex(mutexId, description);
    }

    public void releaseMutex(String mutexId) {
        this.mutexSupport.releaseMutex(mutexId);
    }

    public boolean hasMutex(String mutexId) {
        return this.mutexSupport.hasMutex(mutexId);
    }

    public Objects.ToStringHelper string() {
        return super.string().omitNullValues().add("provisioner", this.provisioner).add("infrastructure", (Object)this.infrastructure).add("strategy", (Object)this.strategy);
    }
}

