/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.enricher.Enrichers;
import brooklyn.entity.Application;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.BasicGroup;
import brooklyn.entity.basic.BasicStartableImpl;
import brooklyn.entity.basic.DelegateEntity;
import brooklyn.entity.basic.DynamicGroup;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.docker.DockerAttributes;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.group.Cluster;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.group.DynamicMultiGroup;
import brooklyn.entity.machine.MachineAttributes;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.location.basic.BasicLocationDefinition;
import brooklyn.location.docker.DockerContainerLocation;
import brooklyn.location.docker.DockerLocation;
import brooklyn.management.LocationManager;
import brooklyn.management.ManagementContext;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.time.Duration;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerInfrastructureImpl
extends BasicStartableImpl
implements DockerInfrastructure {
    private static final Logger LOG;
    private DynamicCluster hosts;
    private DynamicGroup fabric;
    private DynamicMultiGroup buckets;
    private final transient AtomicBoolean started = new AtomicBoolean(false);
    private Predicate<Entity> sameInfrastructure = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity input) {
            Optional lookup = Iterables.tryFind((Iterable)input.getLocations(), (Predicate)Predicates.instanceOf(DockerContainerLocation.class));
            if (lookup.isPresent()) {
                DockerContainerLocation container = (DockerContainerLocation)((Object)lookup.get());
                return DockerInfrastructureImpl.this.getId().equals(container.getOwner().getDockerHost().getInfrastructure().getId());
            }
            return false;
        }
    };

    public void init() {
        LOG.info("Starting Docker infrastructure id {}", (Object)this.getId());
        super.init();
        int initialSize = (Integer)this.getConfig(DOCKER_HOST_CLUSTER_MIN_SIZE);
        EntitySpec dockerHostSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.getConfig((ConfigKey.HasConfigKey)DOCKER_HOST_SPEC))).configure(DockerHost.DOCKER_INFRASTRUCTURE, (Object)this).configure(SoftwareProcess.SUGGESTED_VERSION, this.getConfig(DOCKER_VERSION)).configure(SoftwareProcess.CHILDREN_STARTABLE_MODE, (Object)SoftwareProcess.ChildStartableMode.BACKGROUND_LATE);
        this.hosts = (DynamicCluster)this.addChild((EntitySpec)EntitySpec.create(DynamicCluster.class).configure((ConfigKey)Cluster.INITIAL_SIZE, (Object)initialSize).configure(DynamicCluster.QUARANTINE_FAILED_ENTITIES, (Object)true).configure(DynamicCluster.MEMBER_SPEC, (Object)dockerHostSpec).displayName("Docker Hosts"));
        this.fabric = (DynamicGroup)this.addChild((EntitySpec)EntitySpec.create(DynamicGroup.class).configure(DynamicGroup.ENTITY_FILTER, (Object)Predicates.and((Predicate)Predicates.instanceOf(DockerContainer.class), (Predicate)EntityPredicates.attributeEqualTo(DockerContainer.DOCKER_INFRASTRUCTURE, (Object)this))).configure(DynamicGroup.MEMBER_DELEGATE_CHILDREN, (Object)true).displayName("All Docker Containers"));
        this.buckets = (DynamicMultiGroup)this.addChild((EntitySpec)EntitySpec.create(DynamicMultiGroup.class).configure(DynamicMultiGroup.ENTITY_FILTER, this.sameInfrastructure).configure(DynamicMultiGroup.RESCAN_INTERVAL, (Object)15L).configure(DynamicMultiGroup.BUCKET_FUNCTION, (Object)new Function<Entity, String>(){

            public String apply(@Nullable Entity input) {
                return input.getApplication().getDisplayName();
            }
        }).configure(DynamicMultiGroup.BUCKET_SPEC, (Object)EntitySpec.create(BasicGroup.class).configure(BasicGroup.MEMBER_DELEGATE_CHILDREN, (Object)true)).displayName("Docker Applications"));
        if (Entities.isManaged((Entity)this)) {
            Entities.manage((Entity)this.hosts);
            Entities.manage((Entity)this.fabric);
            Entities.manage((Entity)this.buckets);
        }
        this.setAttribute(DOCKER_HOST_CLUSTER, this.hosts);
        this.setAttribute(DOCKER_CONTAINER_FABRIC, this.fabric);
        this.setAttribute(DOCKER_APPLICATIONS, this.buckets);
        this.hosts.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(DockerHost.CPU_USAGE).computingAverage()).fromMembers()).publishing(MachineAttributes.AVERAGE_CPU_USAGE).valueToReportIfNoSensors((Object)0.0)).build());
        this.hosts.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(DOCKER_CONTAINER_COUNT).computingSum()).fromMembers()).publishing(DOCKER_CONTAINER_COUNT).build());
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{DOCKER_CONTAINER_COUNT, MachineAttributes.AVERAGE_CPU_USAGE}).from((Entity)this.hosts)).build());
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating((Map)ImmutableMap.of((Object)DynamicCluster.GROUP_SIZE, (Object)DOCKER_HOST_COUNT)).from((Entity)this.hosts)).build());
    }

    @Override
    public List<Entity> getDockerHostList() {
        if (this.hosts == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)this.hosts.getMembers());
    }

    @Override
    public DynamicCluster getDockerHostCluster() {
        return this.hosts;
    }

    @Override
    public List<Entity> getDockerContainerList() {
        if (this.fabric == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)this.fabric.getMembers());
    }

    @Override
    public DynamicGroup getContainerFabric() {
        return this.fabric;
    }

    public Integer resize(Integer desiredSize) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resize Docker infrastructure to {} at {}", new Object[]{desiredSize, this.getLocations()});
        }
        return this.hosts.resize(desiredSize);
    }

    public Integer getCurrentSize() {
        return this.hosts.getCurrentSize();
    }

    public DockerLocation getDynamicLocation() {
        return (DockerLocation)this.getAttribute(DYNAMIC_LOCATION);
    }

    public boolean isLocationAvailable() {
        return this.started.get() && this.getDynamicLocation() != null;
    }

    public DockerLocation createLocation(Map<String, ?> flags) {
        String locationName = (String)this.getConfig((ConfigKey.HasConfigKey)LOCATION_NAME);
        if (locationName == null) {
            String prefix = (String)this.getConfig(LOCATION_NAME_PREFIX);
            String suffix = (String)this.getConfig(LOCATION_NAME_SUFFIX);
            locationName = Joiner.on((String)"-").skipNulls().join((Object)prefix, (Object)this.getId(), new Object[]{suffix});
        }
        String locationSpec = String.format("docker:%s", this.getId()) + String.format(":(name=\"%s\")", locationName);
        this.setAttribute(LOCATION_SPEC, locationSpec);
        BasicLocationDefinition definition = new BasicLocationDefinition(locationName, locationSpec, flags);
        Location location = this.getManagementContext().getLocationRegistry().resolve((LocationDefinition)definition);
        this.getManagementContext().getLocationRegistry().updateDefinedLocation((LocationDefinition)definition);
        this.getManagementContext().getLocationManager().manage(location);
        this.getManagementContext().addPropertiesReloadListener(new ManagementContext.PropertiesReloadListener((LocationDefinition)definition){
            final /* synthetic */ LocationDefinition val$definition;
            {
                this.val$definition = locationDefinition;
            }

            public void reloaded() {
                if (DockerInfrastructureImpl.this.started.get()) {
                    Location resolved = DockerInfrastructureImpl.this.getManagementContext().getLocationRegistry().resolve(this.val$definition);
                    DockerInfrastructureImpl.this.getManagementContext().getLocationRegistry().updateDefinedLocation(this.val$definition);
                    DockerInfrastructureImpl.this.getManagementContext().getLocationManager().manage(resolved);
                }
            }
        });
        this.setAttribute(DYNAMIC_LOCATION, location);
        this.setAttribute((AttributeSensor)LOCATION_NAME, location.getId());
        LOG.info("New Docker location {} created", (Object)location);
        return (DockerLocation)location;
    }

    public void deleteLocation() {
        LocationManager mgr;
        DockerLocation location = this.getDynamicLocation();
        if (location != null && (mgr = this.getManagementContext().getLocationManager()).isManaged((Location)location)) {
            mgr.unmanage((Location)location);
        }
        this.setAttribute(DYNAMIC_LOCATION, null);
        this.setAttribute((AttributeSensor)LOCATION_NAME, null);
    }

    public void start(Collection<? extends Location> locations) {
        if (this.started.compareAndSet(false, true)) {
            this.setAttribute(SERVICE_UP, Boolean.FALSE);
            Location provisioner = (Location)Iterables.getOnlyElement(locations);
            LOG.info("Creating new DockerLocation wrapping {}", (Object)provisioner);
            MutableMap flags = MutableMap.builder().putAll((Map)this.getConfig(LOCATION_FLAGS)).put((Object)"provisioner", (Object)provisioner).putIfNotNull((Object)"strategy", this.getConfig(PLACEMENT_STRATEGY)).build();
            this.createLocation((Map)flags);
            super.start(locations);
            this.setAttribute(SERVICE_UP, Boolean.TRUE);
        }
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            this.setAttribute(SERVICE_UP, Boolean.FALSE);
            try {
                Iterable entities = Iterables.filter((Iterable)this.getManagementContext().getEntityManager().getEntities(), this.sameInfrastructure);
                ImmutableSet applications = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)entities, (Function)new Function<Entity, Application>(){

                    public Application apply(Entity input) {
                        return input.getApplication();
                    }
                }));
                Entities.invokeEffectorList((EntityLocal)this, (Iterable)applications, (Effector)Startable.STOP).get(Duration.FIVE_MINUTES);
            }
            catch (Exception e) {
                LOG.warn("Error stopping applications: {}", (Throwable)e);
            }
            super.stop();
            this.deleteLocation();
        }
    }

    static {
        DockerAttributes.init();
        RendererHints.register((Object)DOCKER_HOST_CLUSTER, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((Object)DOCKER_CONTAINER_FABRIC, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((Object)DOCKER_APPLICATIONS, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        LOG = LoggerFactory.getLogger(DockerInfrastructureImpl.class);
    }
}

