/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.annotation.EffectorParam;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.docker.DockerAttributes;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHostImpl;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.machine.MachineEntity;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.HasShortName;
import brooklyn.entity.trait.Resizable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.affinity.AffinityRules;
import brooklyn.location.basic.PortRanges;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.dynamic.LocationOwner;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.networking.subnet.PortForwarder;
import brooklyn.networking.subnet.SubnetTier;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Duration;
import java.util.List;
import java.util.Map;

@ImplementedBy(value=DockerHostImpl.class)
public interface DockerHost
extends MachineEntity,
Resizable,
HasShortName,
LocationOwner<DockerHostLocation, DockerHost> {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = DockerInfrastructure.DOCKER_VERSION;
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"https://get.docker.io/builds/Linux/x86_64/docker-latest");
    @SetFromFlag(value="maxSize")
    public static final ConfigKey<Integer> DOCKER_CONTAINER_CLUSTER_MAX_SIZE = DockerInfrastructure.DOCKER_CONTAINER_CLUSTER_MAX_SIZE;
    @SetFromFlag(value="maxCpu")
    public static final ConfigKey<Double> DOCKER_CONTAINER_CLUSTER_MAX_CPU = DockerInfrastructure.DOCKER_CONTAINER_CLUSTER_MAX_CPU;
    @SetFromFlag(value="highAvailabilty")
    public static final ConfigKey<Boolean> HA_POLICY_ENABLE = ConfigKeys.newBooleanConfigKey((String)"docker.policy.ha.enable", (String)"Enable high-availability and resilience/restart policies", (Boolean)false);
    @SetFromFlag(value="dockerPort")
    public static final PortAttributeSensorAndConfigKey DOCKER_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"docker.port", (String)"Docker port", (Object)PortRanges.fromString((String)"2375"));
    @SetFromFlag(value="dockerSslPort")
    public static final PortAttributeSensorAndConfigKey DOCKER_SSL_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"docker.ssl.port", (String)"Docker port", (Object)PortRanges.fromString((String)"2376"));
    @SetFromFlag(value="containerSpec")
    public static final AttributeSensorAndConfigKey<EntitySpec, EntitySpec> DOCKER_CONTAINER_SPEC = ConfigKeys.newSensorAndConfigKey(EntitySpec.class, (String)"docker.container.spec", (String)"Specification to use when creating child Docker container", (Object)EntitySpec.create(DockerContainer.class));
    @SetFromFlag(value="infrastructure")
    public static final AttributeSensorAndConfigKey<DockerInfrastructure, DockerInfrastructure> DOCKER_INFRASTRUCTURE = ConfigKeys.newSensorAndConfigKey(DockerInfrastructure.class, (String)"docker.infrastructure", (String)"The parent Docker infrastructure");
    public static final ConfigKey<String> HOST_NAME_FORMAT = ConfigKeys.newStringConfigKey((String)"docker.host.nameFormat", (String)"Format for generating Docker host names", (String)"docker-host-brooklyn-%1$s");
    @SetFromFlag(value="repository")
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_REPOSITORY = ConfigKeys.newStringSensorAndConfigKey((String)"docker.repository", (String)"The name of the Docker repository for images");
    public static final ConfigKey<? extends String> EPEL_RELEASE = ConfigKeys.newStringConfigKey((String)"docker.host.epel.release", (String)"EPEL release for yum based OS", (String)"6-8");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_IMAGE_ID = DockerAttributes.DOCKER_IMAGE_ID;
    public static final AttributeSensor<String> DOCKER_IMAGE_NAME = DockerAttributes.DOCKER_IMAGE_NAME;
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_HARDWARE_ID = DockerAttributes.DOCKER_HARDWARE_ID;
    @SetFromFlag(value="volumeMappings")
    public static final AttributeSensorAndConfigKey<Map<String, String>, Map<String, String>> DOCKER_HOST_VOLUME_MAPPING = DockerAttributes.DOCKER_HOST_VOLUME_MAPPING;
    @SetFromFlag(value="affinityRules")
    public static final ConfigKey<String> DOCKER_HOST_AFFINITY_RULES = AffinityRules.AFFINITY_RULES;
    @SetFromFlag(value="password")
    public static final ConfigKey<String> DOCKER_PASSWORD = DockerAttributes.DOCKER_PASSWORD;
    public static final AttributeSensor<String> DOCKER_HOST_NAME = Sensors.newStringSensor((String)"docker.host.name", (String)"The name of the Docker host");
    public static final MethodEffector<String> CREATE_SSHABLE_IMAGE = new MethodEffector(DockerHost.class, "createSshableImage");
    public static final MethodEffector<String> RUN_DOCKER_COMMAND = new MethodEffector(DockerHost.class, "runDockerCommand");
    public static final MethodEffector<String> RUN_DOCKER_COMMAND_TIMEOUT = new MethodEffector(DockerHost.class, "runDockerCommandTimeout");
    public static final MethodEffector<String> DEPLOY_ARCHIVE = new MethodEffector(DockerHost.class, "deployArchive");

    public String getRepository();

    public String getPassword();

    public Integer getDockerPort();

    public JcloudsLocation getJcloudsLocation();

    public PortForwarder getPortForwarder();

    public SubnetTier getSubnetTier();

    public String getDockerHostName();

    public DynamicCluster getDockerContainerCluster();

    public List<Entity> getDockerContainerList();

    public DockerInfrastructure getInfrastructure();

    @Effector(description="Create an SSHable image and returns the image ID")
    public String createSshableImage(@EffectorParam(name="dockerFile", description="URL of Dockerfile to copy") String var1, @EffectorParam(name="folder", description="Repository name") String var2);

    @Effector(description="Execute a Docker command and return the output")
    public String runDockerCommand(@EffectorParam(name="command", description="Docker command") String var1);

    @Effector(description="Execute a Docker command and return the output")
    public String runDockerCommandTimeout(@EffectorParam(name="command", description="Docker command") String var1, @EffectorParam(name="timeout", description="Timeout") Duration var2);

    @Effector(description="Upload an archive file to the host and expand it, for export to a container")
    public String deployArchive(@EffectorParam(name="url", description="Archive source URL") String var1);
}

