/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.BasicStartableImpl;
import brooklyn.entity.basic.DelegateEntity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.event.feed.function.FunctionFeed;
import brooklyn.event.feed.function.FunctionPollConfig;
import brooklyn.location.Location;
import brooklyn.location.LocationSpec;
import brooklyn.location.NoMachinesAvailableException;
import brooklyn.location.PortRange;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.cloud.CloudLocationConfig;
import brooklyn.location.docker.DockerContainerLocation;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.dynamic.DynamicLocation;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsLocationConfig;
import brooklyn.location.jclouds.JcloudsSshMachineLocation;
import brooklyn.location.jclouds.templates.PortableTemplateBuilder;
import brooklyn.management.LocationManager;
import brooklyn.networking.portforwarding.subnet.JcloudsPortforwardingSubnetLocation;
import brooklyn.networking.subnet.SubnetTier;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.internal.ssh.SshTool;
import brooklyn.util.net.Cidr;
import brooklyn.util.net.Urls;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.docker.compute.options.DockerTemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainerImpl
extends BasicStartableImpl
implements DockerContainer {
    private static final Logger LOG = LoggerFactory.getLogger(DockerContainerImpl.class);
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private transient FunctionFeed sensorFeed;

    public void init() {
        LOG.info("Starting Docker container id {}", (Object)this.getId());
        super.init();
        String dockerContainerName = String.format((String)this.getConfig(DockerContainer.DOCKER_CONTAINER_NAME_FORMAT), this.getId(), COUNTER.incrementAndGet());
        this.setDisplayName(dockerContainerName);
        this.setAttribute(DOCKER_CONTAINER_NAME, dockerContainerName);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_INFRASTRUCTURE);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_HOST);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)ENTITY);
    }

    protected void connectSensors() {
        this.sensorFeed = FunctionFeed.builder().entity((EntityLocal)this).period(Duration.TEN_SECONDS).poll(new FunctionPollConfig(SERVICE_UP).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return DockerContainerImpl.this.getDynamicLocation().getMachine().isSshable();
            }
        })).poll(new FunctionPollConfig(CONTAINER_RUNNING).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String running = DockerContainerImpl.this.getDockerHost().runDockerCommand("inspect -f {{.State.Running}} " + DockerContainerImpl.this.getContainerId());
                return Boolean.parseBoolean(Strings.trim((String)running));
            }
        })).build();
    }

    public void disconnectSensors() {
        if (this.sensorFeed != null) {
            this.sensorFeed.stop();
        }
    }

    @Override
    public Entity getRunningEntity() {
        return (Entity)this.getAttribute((AttributeSensor)ENTITY);
    }

    @Override
    public void setRunningEntity(Entity entity) {
        this.setAttribute((AttributeSensor)ENTITY, entity);
    }

    @Override
    public String getDockerContainerName() {
        return (String)this.getAttribute(DOCKER_CONTAINER_NAME);
    }

    @Override
    public String getContainerId() {
        return (String)this.getAttribute(CONTAINER_ID);
    }

    @Override
    public SshMachineLocation getMachine() {
        return (SshMachineLocation)this.getAttribute(SSH_MACHINE_LOCATION);
    }

    @Override
    public DockerHost getDockerHost() {
        return (DockerHost)this.getConfig((ConfigKey.HasConfigKey)DOCKER_HOST);
    }

    public String getShortName() {
        return "Docker Container";
    }

    public DockerContainerLocation getDynamicLocation() {
        return (DockerContainerLocation)((Object)this.getAttribute(DYNAMIC_LOCATION));
    }

    public boolean isLocationAvailable() {
        return this.getDynamicLocation() != null;
    }

    @Override
    public void shutDown() {
        String dockerContainerName = (String)this.getAttribute(DockerContainer.DOCKER_CONTAINER_NAME);
        LOG.info("Shut-Down {}", (Object)dockerContainerName);
        this.getDockerHost().runDockerCommand("kill " + this.getContainerId());
    }

    @Override
    public void pause() {
        String dockerContainerName = (String)this.getAttribute(DockerContainer.DOCKER_CONTAINER_NAME);
        LOG.info("Pausing {}", (Object)dockerContainerName);
        this.getDockerHost().runDockerCommand("stop " + this.getContainerId());
    }

    @Override
    public void resume() {
        String dockerContainerName = (String)this.getAttribute(DockerContainer.DOCKER_CONTAINER_NAME);
        LOG.info("Resume {}", (Object)dockerContainerName);
        this.getDockerHost().runDockerCommand("start" + this.getContainerId());
    }

    private DockerTemplateOptions getDockerTemplateOptions() {
        List exports;
        Integer memory;
        Integer cpuShares;
        Entity entity = this.getRunningEntity();
        DockerTemplateOptions options = DockerTemplateOptions.NONE;
        Boolean useHostDns = (Boolean)entity.getConfig(DOCKER_USE_HOST_DNS_NAME);
        if (useHostDns == null) {
            useHostDns = (Boolean)this.getConfig(DOCKER_USE_HOST_DNS_NAME);
        }
        if (useHostDns != null && useHostDns.booleanValue()) {
            String address;
            String hostname = (String)this.getDockerHost().getAttribute(Attributes.HOSTNAME);
            if (hostname.equalsIgnoreCase(address = (String)this.getDockerHost().getAttribute(Attributes.ADDRESS))) {
                options.hostname(this.getDockerContainerName());
            } else {
                options.hostname(hostname);
            }
        }
        if ((cpuShares = (Integer)entity.getConfig(DOCKER_CPU_SHARES)) == null) {
            cpuShares = (Integer)this.getConfig(DOCKER_CPU_SHARES);
        }
        if (cpuShares != null) {
            TemplateBuilder template;
            Integer hostCores = (int)((DockerHostLocation)this.getDockerHost().getDynamicLocation()).getMachine().getMachineDetails().getHardwareDetails().getCpuCount();
            Integer minCores = (Integer)entity.getConfig(JcloudsLocationConfig.MIN_CORES);
            Map flags = (Map)entity.getConfig((ConfigKey)SoftwareProcess.PROVISIONING_PROPERTIES);
            if (minCores == null && flags != null) {
                minCores = (Integer)flags.get(JcloudsLocationConfig.MIN_CORES.getName());
            }
            if (minCores == null && flags != null && (template = (TemplateBuilder)flags.get(JcloudsLocationConfig.TEMPLATE_BUILDER.getName())) != null) {
                minCores = 0;
                for (Processor cpu : template.build().getHardware().getProcessors()) {
                    minCores = minCores + (int)cpu.getCores();
                }
            }
            if (minCores != null) {
                double ratio = (double)minCores.intValue() / (double)hostCores.intValue();
                LOG.info("Cores: host {}, min {}, ratio {}", new Object[]{hostCores, minCores, ratio});
            }
        }
        if (cpuShares != null) {
            options.cpuShares(cpuShares);
        }
        if ((memory = (Integer)entity.getConfig(DOCKER_MEMORY)) == null) {
            memory = (Integer)this.getConfig(DOCKER_MEMORY);
        }
        if (memory != null) {
            TemplateBuilder template;
            Integer hostRam = ((DockerHostLocation)this.getDockerHost().getDynamicLocation()).getMachine().getMachineDetails().getHardwareDetails().getRam();
            Integer minRam = (Integer)entity.getConfig(JcloudsLocationConfig.MIN_RAM);
            Map flags = (Map)entity.getConfig((ConfigKey)SoftwareProcess.PROVISIONING_PROPERTIES);
            if (minRam == null && flags != null) {
                minRam = (Integer)flags.get(JcloudsLocationConfig.MIN_RAM.getName());
            }
            if (minRam == null && flags != null && (template = (TemplateBuilder)flags.get(JcloudsLocationConfig.TEMPLATE_BUILDER.getName())) != null) {
                minRam = template.build().getHardware().getRam();
            }
            if (minRam != null) {
                double ratio = (double)minRam.intValue() / (double)hostRam.intValue();
                LOG.info("Memory: host {}, min {}, ratio {}", new Object[]{hostRam, minRam, ratio});
            }
        }
        if (memory != null) {
            options.memory(memory);
        }
        MutableMap volumes = MutableMap.copyOf((Map)((Map)this.getDockerHost().getAttribute((AttributeSensor)DockerHost.DOCKER_HOST_VOLUME_MAPPING)));
        Map mapping = (Map)entity.getConfig(DockerHost.DOCKER_HOST_VOLUME_MAPPING);
        if (mapping != null) {
            for (String source : mapping.keySet()) {
                if (Urls.isUrlWithProtocol((String)source)) {
                    String path = this.getDockerHost().deployArchive(source);
                    volumes.put(path, mapping.get(source));
                    continue;
                }
                volumes.put(source, mapping.get(source));
            }
        }
        if ((exports = (List)entity.getConfig(DockerContainer.DOCKER_CONTAINER_VOLUME_EXPORT)) != null) {
            for (String dir : exports) {
                volumes.put(dir, dir);
            }
        }
        options.volumes((Map)volumes);
        options.overrideLoginPassword(this.getDockerHost().getPassword());
        return options;
    }

    public DockerContainerLocation createLocation(Map flags) {
        DockerHost dockerHost = this.getDockerHost();
        DockerHostLocation host = (DockerHostLocation)dockerHost.getDynamicLocation();
        SubnetTier subnetTier = dockerHost.getSubnetTier();
        String password = (String)this.getConfig(DOCKER_PASSWORD);
        DockerTemplateOptions options = this.getDockerTemplateOptions();
        MutableMap dockerFlags = MutableMap.builder().put((Object)JcloudsLocationConfig.TEMPLATE_BUILDER, (Object)new PortableTemplateBuilder().options((TemplateOptions)options)).put((Object)JcloudsLocationConfig.IMAGE_ID, this.getConfig(DOCKER_IMAGE_ID)).put((Object)JcloudsLocationConfig.HARDWARE_ID, this.getConfig(DOCKER_HARDWARE_ID)).put((Object)LocationConfigKeys.USER, (Object)"root").put((Object)LocationConfigKeys.PASSWORD, (Object)password).put((Object)LocationConfigKeys.PRIVATE_KEY_DATA, null).put((Object)LocationConfigKeys.PRIVATE_KEY_FILE, null).put((Object)CloudLocationConfig.WAIT_FOR_SSHABLE, (Object)false).put((Object)JcloudsLocationConfig.INBOUND_PORTS, this.getRequiredOpenPorts(this.getRunningEntity())).put((Object)JcloudsLocation.USE_PORT_FORWARDING, (Object)true).put((Object)JcloudsLocation.PORT_FORWARDER, (Object)subnetTier.getPortForwarderExtension()).put((Object)JcloudsLocation.PORT_FORWARDING_MANAGER, (Object)subnetTier.getPortForwardManager()).put((Object)JcloudsPortforwardingSubnetLocation.PORT_FORWARDER, (Object)subnetTier.getPortForwarder()).put((Object)SubnetTier.SUBNET_CIDR, (Object)Cidr.CLASS_B).build();
        try {
            JcloudsSshMachineLocation container = host.getJcloudsLocation().obtain((Map)dockerFlags);
            this.setAttribute(CONTAINER_ID, container.getNode().getId());
            LocationSpec spec = (LocationSpec)LocationSpec.create(DockerContainerLocation.class).parent((Location)host).configure(flags).configure(DynamicLocation.OWNER, (Object)this).configure((CharSequence)"machine", (Object)container).configure(container.getAllConfig(true)).configure(SshTool.PROP_PASSWORD, (Object)password).displayName(this.getDockerContainerName());
            DockerContainerLocation location = (DockerContainerLocation)this.getManagementContext().getLocationManager().createLocation(spec);
            this.setAttribute(DYNAMIC_LOCATION, (Object)location);
            this.setAttribute((AttributeSensor)LOCATION_NAME, location.getId());
            LOG.info("New Docker container location {} created", (Object)location);
            return location;
        }
        catch (NoMachinesAvailableException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void deleteLocation() {
        LocationManager mgr;
        DockerContainerLocation location = this.getDynamicLocation();
        if (location != null && (mgr = this.getManagementContext().getLocationManager()).isManaged((Location)location)) {
            mgr.unmanage((Location)location);
        }
        this.setAttribute(DYNAMIC_LOCATION, null);
        this.setAttribute((AttributeSensor)LOCATION_NAME, null);
    }

    protected Collection<Integer> getRequiredOpenPorts(Entity entity) {
        MutableSet ports = MutableSet.of((Object)22);
        for (ConfigKey k : entity.getEntityType().getConfigKeys()) {
            PortRange p;
            if (!PortRange.class.isAssignableFrom(k.getType()) || (p = (PortRange)entity.getConfig(k)) == null || p.isEmpty()) continue;
            ports.add(p.iterator().next());
        }
        LOG.debug("getRequiredOpenPorts detected default {} for {}", (Object)ports, (Object)entity);
        return ports;
    }

    public void start(Collection<? extends Location> locations) {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        this.setAttribute(SoftwareProcess.SERVICE_UP, Boolean.FALSE);
        MutableMap flags = MutableMap.copyOf((Map)((Map)this.getConfig(LOCATION_FLAGS)));
        this.createLocation((Map)flags);
        this.setAttribute(SSH_MACHINE_LOCATION, this.getDynamicLocation().getMachine());
        this.connectSensors();
        super.start(locations);
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.RUNNING);
    }

    public void stop() {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPING);
        super.stop();
        this.disconnectSensors();
        this.setAttribute(SSH_MACHINE_LOCATION, null);
        this.deleteLocation();
        this.setAttribute(SoftwareProcess.SERVICE_UP, Boolean.FALSE);
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPED);
    }

    static {
        RendererHints.register((Object)DOCKER_HOST, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((Object)ENTITY, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((Object)CONTAINER, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
    }
}

