/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.database.DatastoreMixins;
import brooklyn.entity.messaging.MessageBroker;
import brooklyn.entity.nosql.couchbase.CouchbaseNode;
import brooklyn.entity.webapp.WebAppServiceConstants;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.docker.strategy.DockerAwarePlacementStrategy;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.internal.ssh.SshTool;
import brooklyn.util.javalang.Reflections;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.Strings;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class DockerAttributes {
    public static final String DOCKERFILE = "Dockerfile";
    public static final String MAPPED = "mapped";
    public static final String ENDPOINT = "endpoint";
    public static final String PORT = "port";
    public static final Set<String> URL_SENSOR_NAMES = ImmutableSet.of((Object)WebAppServiceConstants.ROOT_URL.getName(), (Object)DatastoreMixins.DATASTORE_URL.getName(), (Object)CouchbaseNode.COUCHBASE_WEB_ADMIN_URL.getName(), (Object)MessageBroker.BROKER_URL.getName());
    public static final String DEFAULT_DOCKER_CONTAINER_NAME_FORMAT = "docker-container-brooklyn-%1$s";
    public static final String DEFAULT_DOCKER_HOST_NAME_FORMAT = "docker-host-brooklyn-%1$s";
    public static final String UBUNTU_DOCKERFILE = "classpath://brooklyn/entity/container/docker/ubuntu/Dockerfile";
    public static final String UBUNTU_USES_JAVA_DOCKERFILE = "classpath://brooklyn/entity/container/docker/ubuntu/UsesJavaDockerfile";
    public static final String CENTOS_DOCKERFILE = "classpath://brooklyn/entity/container/docker/centos/Dockerfile";
    public static final String COREOS_DOCKERFILE = "classpath://brooklyn/entity/container/docker/coreos/Dockerfile";
    public static final String SSHD_DOCKERFILE = "classpath://brooklyn/entity/container/docker/SshdDockerfile";
    public static final CharMatcher DOCKERFILE_CHARACTERS = CharMatcher.anyOf((CharSequence)"_").or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'0', (char)'9'));
    public static final CharMatcher DOCKERFILE_INVALID_CHARACTERS = DOCKERFILE_CHARACTERS.negate();
    public static final ConfigKey<String> DOCKERFILE_URL = ConfigKeys.newStringConfigKey((String)"docker.dockerfile.url", (String)"URL of a Dockerfile to use");
    public static final ConfigKey<String> DOCKERFILE_NAME = ConfigKeys.newStringConfigKey((String)"docker.dockerfile.name", (String)"Name for the image created by the Dockerfile being used");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_IMAGE_ID = ConfigKeys.newStringSensorAndConfigKey((String)"docker.imageId", (String)"The ID of a Docker image to use for a container");
    public static final AttributeSensor<String> DOCKER_IMAGE_NAME = Sensors.newStringSensor((String)"docker.imageName", (String)"The name of the Docker image use used by a container");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_HARDWARE_ID = ConfigKeys.newSensorAndConfigKey(String.class, (String)"docker.hardwareId", (String)"The ID of a Docker hardware type to use for a container", (Object)"small");
    public static final ConfigKey<String> DOCKER_PASSWORD = ConfigKeys.newConfigKeyWithPrefix((String)"docker.", (ConfigKey)SshTool.PROP_PASSWORD);
    public static final ConfigKey<Boolean> DOCKER_USE_HOST_DNS_NAME = ConfigKeys.newBooleanConfigKey((String)"docker.useHostDnsName", (String)"Container uses same DNS hostname as Docker host", (Boolean)Boolean.TRUE);
    public static final ConfigKey<Integer> DOCKER_CPU_SHARES = ConfigKeys.newIntegerConfigKey((String)"docker.cpuShares", (String)"Container CPU shares configuration");
    public static final ConfigKey<Integer> DOCKER_MEMORY = ConfigKeys.newIntegerConfigKey((String)"docker.memory", (String)"Container memory configuration");
    public static final ConfigKey<Boolean> MANAGED = ConfigKeys.newBooleanConfigKey((String)"docker.container.managed", (String)"Set to false if the container is not managed by Brooklyn and Clocker", (Boolean)Boolean.TRUE);
    public static final AttributeSensorAndConfigKey<Map<String, String>, Map<String, String>> DOCKER_HOST_VOLUME_MAPPING = ConfigKeys.newSensorAndConfigKey((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"docker.host.volumes", (String)"Host volume mapping configuration");
    public static final ConfigKey<List<String>> DOCKER_CONTAINER_VOLUME_EXPORT = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"docker.container.volumes", (String)"Container volume export configuration");
    public static final AttributeSensor<Integer> DOCKER_HOST_COUNT = Sensors.newIntegerSensor((String)"docker.hostCount", (String)"Number of Docker hosts");
    public static final AttributeSensor<Integer> DOCKER_CONTAINER_COUNT = Sensors.newIntegerSensor((String)"docker.containerCount", (String)"Number of Docker containers");
    public static final AttributeSensor<Integer> DOCKER_IDLE_HOST_COUNT = Sensors.newIntegerSensor((String)"docker.hostCount.idle", (String)"Number of idle Docker hosts");
    public static final AttributeSensor<Integer> DOCKER_IDLE_CONTAINER_COUNT = Sensors.newIntegerSensor((String)"docker.containerCount.idle", (String)"Number of idle Docker containers");
    public static final Function<String, String> ALLOWED = new Function<String, String>(){

        public String apply(@Nullable String input) {
            if (input == null) {
                return null;
            }
            return DOCKERFILE_INVALID_CHARACTERS.collapseFrom((CharSequence)input.toLowerCase(Locale.ENGLISH), '_');
        }
    };
    private static AtomicBoolean initialized = new AtomicBoolean(false);

    private DockerAttributes() {
    }

    public static <T> AttributeSensor<T> mappedSensor(AttributeSensor<?> source) {
        return Sensors.newSensorWithPrefix((String)"mapped.", source);
    }

    public static AttributeSensor<String> mappedPortSensor(PortAttributeSensorAndConfigKey source) {
        return Sensors.newStringSensor((String)("mapped." + source.getName()), (String)(source.getDescription() + " (Docker mapping)"));
    }

    public static AttributeSensor<String> endpointSensor(PortAttributeSensorAndConfigKey source) {
        List name = Lists.transform((List)source.getNameParts(), (Function)new Function<String, String>(){

            public String apply(@Nullable String input) {
                String target = DockerAttributes.PORT;
                if (input.equals(target)) {
                    return DockerAttributes.ENDPOINT;
                }
                if (input.endsWith(target)) {
                    return input.replace(target, DockerAttributes.ENDPOINT);
                }
                target = Strings.toInitialCapOnly((String)DockerAttributes.PORT);
                if (input.endsWith(target)) {
                    return input.replace(target, Strings.toInitialCapOnly((String)DockerAttributes.ENDPOINT));
                }
                return input;
            }
        });
        if (!name.contains(ENDPOINT)) {
            name.add(ENDPOINT);
        }
        return Sensors.newStringSensor((String)Joiner.on((String)".").join((Iterable)name), (String)(source.getDescription() + " (Docker mapping)"));
    }

    public static String allowed(String input) {
        return (String)ALLOWED.apply((Object)input);
    }

    public static String checkId(String input) {
        String imageId = Strings.trim((String)input).toLowerCase(Locale.ENGLISH);
        if (imageId.length() == 64 && DOCKERFILE_CHARACTERS.matchesAllOf((CharSequence)imageId)) {
            return imageId;
        }
        throw new IllegalStateException("Invalid image ID returned: " + imageId);
    }

    public static String imageName(Entity entity, String dockerfile, String repository) {
        String simpleName = entity.getEntityType().getSimpleName();
        String version = (String)entity.getConfig(SoftwareProcess.SUGGESTED_VERSION);
        String label = Joiner.on((String)":").skipNulls().join((Object)simpleName, (Object)version, new Object[]{dockerfile, repository});
        return Identifiers.makeIdFromHash((long)Hashing.md5().hashString((CharSequence)label, Charsets.UTF_8).asLong()).toLowerCase(Locale.ENGLISH);
    }

    public static void init() {
        if (initialized.getAndSet(true)) {
            return;
        }
        TypeCoercions.registerAdapter(String.class, DockerAwarePlacementStrategy.class, (Function)new Function<String, DockerAwarePlacementStrategy>(){

            public DockerAwarePlacementStrategy apply(String input) {
                ClassLoader classLoader = DockerAwarePlacementStrategy.class.getClassLoader();
                Optional strategy = Reflections.invokeConstructorWithArgs((ClassLoader)classLoader, (String)input, (Object[])new Object[0]);
                if (strategy.isPresent()) {
                    return (DockerAwarePlacementStrategy)strategy.get();
                }
                throw new IllegalStateException("Failed to create DockerAwarePlacementStrategy " + input);
            }
        });
    }

    static {
        DockerAttributes.init();
    }
}

