/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.extras.openshift;

import brooklyn.entity.basic.ConfigurableEntityFactory;
import brooklyn.entity.webapp.ElasticJavaWebAppService;
import brooklyn.location.AddressableLocation;
import brooklyn.location.Location;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationResolver;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.management.ManagementContext;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

class OpenshiftLocation
extends AbstractLocation
implements AddressableLocation,
ElasticJavaWebAppService.ElasticJavaWebAppServiceAwareLocation {
    public OpenshiftLocation() {
        super((Map)MutableMap.of());
    }

    public OpenshiftLocation(Map properties) {
        super(properties);
    }

    public String toVerboseString() {
        return Objects.toStringHelper((Object)((Object)this)).omitNullValues().add("id", (Object)this.getId()).add("name", (Object)this.getDisplayName()).add("hostname", (Object)this.getHostname()).add("url", (Object)this.getUrl()).add("user", (Object)this.getUser()).toString();
    }

    public String getHostname() {
        return (String)JavaGroovyEquivalents.elvis((Object)this.getConfigBag().getStringKey("hostname"), (Object)"openshift.redhat.com");
    }

    public String getUrl() {
        return (String)JavaGroovyEquivalents.elvis((Object)this.getConfigBag().getStringKey("url"), (Object)("https://" + this.getHostname() + "/broker"));
    }

    public String getUser() {
        String result = (String)JavaGroovyEquivalents.elvis((Object[])new Object[]{this.getConfigBag().getStringKey("user"), this.getConfigBag().getStringKey("username"), null});
        return (String)Preconditions.checkNotNull((Object)result);
    }

    public String getUsername() {
        return this.getUser();
    }

    public String getPassword() {
        String result = (String)JavaGroovyEquivalents.elvis((Object)this.getConfigBag().getStringKey("password"), null);
        return (String)Preconditions.checkNotNull((Object)result);
    }

    public ConfigurableEntityFactory<ElasticJavaWebAppService> newWebClusterFactory() {
        throw new UnsupportedOperationException("ElasticJavaWebAppService is work in progress");
    }

    public InetAddress getAddress() {
        try {
            return InetAddress.getByName(this.getHostname());
        }
        catch (UnknownHostException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static class Resolver
    implements LocationResolver {
        private ManagementContext managementContext;

        public void init(ManagementContext managementContext) {
            this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
        }

        public String getPrefix() {
            return "openshift";
        }

        public Location newLocationFromString(Map properties, String spec) {
            return this.newLocationFromString(spec, null, properties, (Map)new MutableMap());
        }

        public Location newLocationFromString(Map locationFlags, String spec, LocationRegistry registry) {
            return this.newLocationFromString(spec, registry, registry.getProperties(), locationFlags);
        }

        protected Location newLocationFromString(String spec, LocationRegistry registry, Map properties, Map locationFlags) {
            assert (spec.equals(this.getPrefix())) : "location '" + this.getPrefix() + "' is not currently parametrisable (invalid '" + spec + "')";
            return new OpenshiftLocation(properties);
        }

        public boolean accepts(String spec, LocationRegistry registry) {
            return false;
        }
    }
}

