/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.extras.openshift;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.trait.Startable;
import brooklyn.entity.webapp.JavaWebAppService;
import brooklyn.extras.openshift.OpenshiftExpressAccess;
import brooklyn.extras.openshift.OpenshiftExpressApplicationAccess;
import brooklyn.extras.openshift.OpenshiftLocation;
import brooklyn.location.Location;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.internal.duplicates.ExecUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpenshiftExpressJavaWebAppCluster
extends AbstractEntity
implements Startable,
JavaWebAppService {
    private static final Logger log = LoggerFactory.getLogger(OpenshiftExpressJavaWebAppCluster.class);
    public static final ConfigKey<String> APP_NAME = ConfigKeys.newStringConfigKey((String)"appName", (String)"System name for uniquely referring to application; defaults to Brooklyn999999");
    boolean shouldDestroy = false;

    public OpenshiftExpressJavaWebAppCluster() {
        this((Map)MutableMap.of(), null);
    }

    public OpenshiftExpressJavaWebAppCluster(Map flags) {
        this(flags, null);
    }

    public OpenshiftExpressJavaWebAppCluster(Entity parent) {
        this((Map)MutableMap.of(), parent);
    }

    public OpenshiftExpressJavaWebAppCluster(Map flags, Entity parent) {
        super(flags, parent);
        this.setConfigIfValNonNull(ROOT_WAR, flags.get("war"));
        this.setConfigIfValNonNull(APP_NAME, flags.get("appName"));
    }

    public String getAppName() {
        String appName = (String)this.getConfig(APP_NAME);
        if (appName != null) {
            return appName;
        }
        appName = "Brooklyn" + this.getId();
        if (appName.indexOf("-") >= 0) {
            appName = appName.substring(0, appName.indexOf("-"));
        }
        return appName;
    }

    /*
     * Unable to fully structure code
     */
    public static int execScriptBlocking(String script) {
        command = "";
        continuation = false;
        var6_3 = script.trim().split("\n");
        var5_4 = var6_3.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            block8: {
                it = var6_3[var4_5];
                if (continuation) ** GOTO lbl15
                if (command.length() > 0) {
                    command = String.valueOf(command) + " && ";
                }
                command = String.valueOf(command) + "{ ";
                it = it.trim();
                break block8;
lbl-1000:
                // 1 sources

                {
                    it = it.substring(0, it.length() - 1);
lbl15:
                    // 2 sources

                    ** while (it.length() > 0 && it.charAt((int)(it.length() - 1)) <= ' ')
                }
            }
            command = String.valueOf(command) + it;
            if (it.endsWith("\\")) {
                continuation = true;
            } else {
                continuation = false;
                if (!it.endsWith(";")) {
                    command = String.valueOf(command) + ";";
                }
                command = String.valueOf(command) + " }";
            }
            ++var4_5;
        }
        OpenshiftExpressJavaWebAppCluster.log.info("exec system process: {}", (Object)command);
        try {
            return ExecUtils.execBlocking((String[])new String[]{"/bin/bash", "-cl", command});
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void start(Collection<? extends Location> locations) {
        this.startInLocation(locations);
    }

    public void startInLocation(Collection<? extends Location> locations) {
        Preconditions.checkArgument((locations.size() == 1 ? 1 : 0) != 0, (String)"must be one location but given %s", (Object[])new Object[]{locations});
        Location location = (Location)Iterables.getOnlyElement(locations);
        this.startInLocation((OpenshiftLocation)location);
    }

    public void restart() {
        this.stop();
        this.start(this.getLocations());
    }

    public void stop() {
        this.destroy();
    }

    public void startInLocation(OpenshiftLocation ol) {
        this.addLocations((Collection)ImmutableList.of((Object)((Object)ol)));
        String war = (String)this.getConfig(ROOT_WAR);
        if (war == null) {
            throw new IllegalStateException("A WAR file is required to start " + (Object)((Object)this));
        }
        OpenshiftExpressApplicationAccess osa = new OpenshiftExpressApplicationAccess((Map)MutableMap.of((Object)"username", (Object)ol.getUsername(), (Object)"password", (Object)ol.getPassword(), (Object)"appName", (Object)this.getAppName()));
        OpenshiftExpressAccess.UserInfoResult user = (OpenshiftExpressAccess.UserInfoResult)osa.getUserInfo().getData();
        Object userInfo = null;
        OpenshiftExpressAccess.AppInfoFields appInfo = user.app_info.get(this.getAppName());
        if (appInfo == null) {
            log.debug("{} creating app {}", (Object)this, (Object)this.getAppName());
            this.shouldDestroy = true;
            osa.create((Map)MutableMap.of((Object)"retries", (Object)3));
            user = (OpenshiftExpressAccess.UserInfoResult)osa.getUserInfo().getData();
            appInfo = user.app_info.get(this.getAppName());
        }
        String server = String.valueOf(this.getAppName()) + "-" + userInfo.namespace + "." + userInfo.rhc_domain;
        String gitUrl = "ssh://" + appInfo.uuid + "@" + server + "/~/git/" + this.getAppName() + ".git/";
        String openshiftDir = String.valueOf(AbstractSoftwareProcessSshDriver.BROOKLYN_HOME_DIR) + "/" + this.getApplicationId() + "/openshift-" + this.getId();
        String openshiftGitDir = String.valueOf(openshiftDir) + "/git";
        log.debug("{} gitting app {}, ", (Object)this, (Object)this.getAppName());
        int code = OpenshiftExpressJavaWebAppCluster.execScriptBlocking("mkdir -p " + openshiftGitDir + "\n" + "cd " + openshiftGitDir + "\n" + "echo `date` checking for DNS for " + server + "\n" + "RETRIES_LEFT=10" + "\n" + "while [ $RETRIES_LEFT -gt 0 ]; do { ping -c 1 -t 2 " + server + " > /dev/null && break; } || { let RETRIES_LEFT-=1; echo waiting to retry DNS for " + server + "; sleep 1; } done" + "\n" + "if [ ! $RETRIES_LEFT -gt 0 ]; then echo \"WARNING: timeout contacting server " + server + ", OpenShift DNS probably failed to propagate\"; [[ -z 'failed' ]]; fi" + "\n" + "echo `date` found dns " + server + "\n" + "git clone " + gitUrl + "\n" + "cd " + this.getAppName() + "\n" + "git rm -rf *" + "\n" + "mkdir deployments" + "\n" + "cp " + war + " deployments/ROOT.war" + "\n" + "touch deployments/ROOT.war.dodeploy" + "\n" + "git add deployments" + "\n" + "git commit -m \"brooklyn automated project restructure for deployment of WAR file\"" + "\n" + "git push");
        if (code != 0) {
            throw new IllegalStateException("Failed to deploy " + (Object)((Object)this) + " app " + this.getAppName() + " (" + war + "): code " + code);
        }
        log.info("{} app launched: {}", (Object)this, (Object)this.getAppName());
    }

    public String getWebAppAddress() {
        return String.format("http://%s-brooklyn.rhcloud.com/", this.getAppName());
    }

    public void destroy() {
        if (this.shouldDestroy) {
            log.info("{} destroying app {}", (Object)this, (Object)this.getAppName());
            OpenshiftLocation ol = (OpenshiftLocation)((Object)Iterables.getOnlyElement((Iterable)this.getLocations()));
            OpenshiftExpressApplicationAccess osa = new OpenshiftExpressApplicationAccess((Map)MutableMap.of((Object)"username", (Object)ol.getUsername(), (Object)"password", (Object)ol.getPassword(), (Object)"appName", (Object)this.getAppName()));
            osa.destroy();
        }
    }
}

