/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.extras.openshift;

import brooklyn.extras.openshift.OpenshiftExpressAccess;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftExpressApplicationAccess
extends OpenshiftExpressAccess {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftExpressApplicationAccess.class);
    @SetFromFlag
    OpenshiftExpressAccess.Cartridge cartridge;
    @SetFromFlag(nullable=false)
    String appName;
    @SetFromFlag(defaultVal="false")
    boolean debug;

    OpenshiftExpressApplicationAccess(Map flags) {
        super(flags);
        if (this.cartridge == null) {
            this.cartridge = OpenshiftExpressAccess.Cartridge.JBOSS_AS_7;
        }
    }

    @Override
    protected void validate() {
        super.validate();
        if (!this.appName.matches("[A-Za-z0-9]+")) {
            throw new IllegalArgumentException("appName must contain only alphanumeric characters");
        }
    }

    Map newFields(Map f) {
        LinkedHashMap f2 = Maps.newLinkedHashMap();
        f2.putAll(ImmutableMap.of((Object)"cartridge", (Object)((Object)this.cartridge), (Object)"app_name", (Object)this.appName, (Object)"debug", (Object)("" + this.debug)));
        f2.putAll(f);
        return f2;
    }

    public Object status() {
        return this.doPost(this.newFields((Map)MutableMap.of((Object)"action", (Object)"status")));
    }

    public Object create() {
        return this.create((Map)MutableMap.of());
    }

    public Object create(Map flags) {
        int retries = (Integer)JavaGroovyEquivalents.elvis(flags.get("retries"), (Object)0);
        boolean retry = true;
        while (retry) {
            retry = false;
            try {
                return this.doPost(this.newFields((Map)ImmutableMap.of((Object)"action", (Object)"configure")));
            }
            catch (IllegalStateException e) {
                if (e.toString().indexOf("HTTP/1.1 500 Internal Server Error") >= 0 && retries > 0) {
                    --retries;
                    retry = true;
                    continue;
                }
                if (e.toString().indexOf("HTTP/1.1 400") >= 0) {
                    LOG.warn("creation of application failed (exception will be thrown); note that this can be due to already having the maximum number of applications in Openshift (currently 4)");
                }
                throw e;
            }
        }
        throw new IllegalStateException("unreachable code");
    }

    public Object destroy() {
        return this.doPost(this.newFields((Map)ImmutableMap.of((Object)"action", (Object)"deconfigure")));
    }
}

