/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.extras.openshift;

import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.flags.TypeCoercions;
import com.google.common.collect.Maps;
import groovy.json.JsonBuilder;
import groovy.json.JsonSlurper;
import groovyx.net.http.HTTPBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpenshiftExpressAccess {
    private static final Logger log = LoggerFactory.getLogger(OpenshiftExpressAccess.class);
    @SetFromFlag(defaultVal="https://openshift.redhat.com/broker", nullable=false)
    String urlBase;
    @SetFromFlag(nullable=false)
    String username;
    @SetFromFlag(nullable=false)
    String password;
    UserInfoFields user_info;

    OpenshiftExpressAccess(Map flags) {
        ConfigBag bag = new ConfigBag().putAll(flags);
        FlagUtils.setFieldsFromFlags((Object)this, (ConfigBag)bag, (boolean)true);
    }

    protected void validate() {
        FlagUtils.checkRequiredFields((Object)this);
    }

    public Object doPost(String urlExtension) {
        return this.doPost((Map)MutableMap.of(), urlExtension);
    }

    public Object doPost(Map jsonDataFields) {
        return this.doPost(jsonDataFields, "/cartridge");
    }

    public Object doPost(Map jsonDataFields, String urlExtension) {
        this.validate();
        try {
            new HTTPBuilder((Object)(String.valueOf(this.urlBase) + urlExtension));
            JsonBuilder jsonBuilder = new JsonBuilder();
            LinkedHashMap allFields = Maps.newLinkedHashMap();
            allFields.put("rhlogin", this.username);
            allFields.putAll(jsonDataFields);
            jsonBuilder.call((Map)allFields);
            String jsonData = jsonBuilder.toString();
            log.info("posting to " + this.urlBase + urlExtension + " : " + jsonData);
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public OpenshiftJsonResult<UserInfoResult> getUserInfo() {
        return new OpenshiftJsonResult<UserInfoResult>(this.doPost("/userinfo"), UserInfoResult.class);
    }

    static class AppInfoFields {
        String uuid;
        String creation_time;
        String framework;
        String embedded;

        AppInfoFields() {
        }
    }

    public static enum Cartridge {
        JBOSS_AS_7("jbossas-7.0");

        final String name;

        private Cartridge(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    static class OpenshiftJsonResult<T> {
        Object raw;
        Object dataUntyped;
        T dataTyped = null;
        Class<T> type;

        public OpenshiftJsonResult(Object raw, Class<T> type) {
            this.raw = raw;
            this.type = type;
            this.dataUntyped = new JsonSlurper().parseText(null);
            this.dataTyped = TypeCoercions.coerce((Object)this.dataUntyped, type);
        }

        public T getData() {
            return this.dataTyped;
        }

        public String getMessages() {
            return null;
        }

        public String getApi() {
            return null;
        }

        public String toString() {
            return String.valueOf(this.type.getSimpleName()) + ":" + this.raw;
        }
    }

    static class UserInfoFields {
        String rhc_domain;
        String rhlogin;
        String uuid;
        String ssh_key;
        String namespace;

        UserInfoFields() {
        }
    }

    static class UserInfoResult {
        Map<String, AppInfoFields> app_info;

        UserInfoResult() {
        }
    }
}

