/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne.v41.jcache;

import io.bootique.cayenne.v41.CayenneModule;
import io.bootique.cayenne.v41.jcache.CayenneJCacheModuleExtender;
import io.bootique.di.BQModule;
import io.bootique.di.Binder;
import io.bootique.di.Key;
import io.bootique.di.Provides;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import javax.cache.CacheManager;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import org.apache.cayenne.cache.invalidation.CacheInvalidationModule;
import org.apache.cayenne.cache.invalidation.CacheInvalidationModuleExtender;
import org.apache.cayenne.cache.invalidation.InvalidationHandler;
import org.apache.cayenne.di.Module;

public class CayenneJCacheModule
implements BQModule {
    public static CayenneJCacheModuleExtender extend(Binder binder) {
        return new CayenneJCacheModuleExtender(binder);
    }

    public void configure(Binder binder) {
        CayenneJCacheModule.extend(binder).initAllExtensions();
        CayenneModule.extend((Binder)binder).addModule(Key.get(Module.class, DefinedInCayenneJCache.class));
    }

    @Singleton
    @Provides
    @DefinedInCayenneJCache
    Module provideDiJCacheModule(CacheManager cacheManager, Set<InvalidationHandler> invalidationHandlers) {
        return b -> {
            this.createInvalidationModule(invalidationHandlers).configure(b);
            this.createOverridesModule(cacheManager).configure(b);
        };
    }

    protected Module createInvalidationModule(Set<InvalidationHandler> invalidationHandlers) {
        CacheInvalidationModuleExtender extender = CacheInvalidationModule.extend();
        invalidationHandlers.forEach(arg_0 -> ((CacheInvalidationModuleExtender)extender).addHandler(arg_0));
        return extender.module();
    }

    protected Module createOverridesModule(CacheManager cacheManager) {
        return b -> b.bind(CacheManager.class).toInstance((Object)cacheManager);
    }

    @Target(value={ElementType.PARAMETER, ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface DefinedInCayenneJCache {
    }
}

