/**
 * Copyright 2018 Royal Bank of Scotland
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.bluebank.braid.client.invocations.impl

import io.bluebank.braid.client.invocations.Invocations
import io.bluebank.braid.core.jsonrpc.JsonRPCRequest
import io.vertx.core.Future

/**
 * Internal interface for [InvocationsImpl] used by all [InvocationStrategy] concrete classes
 */
internal interface InvocationsInternal : Invocations {

  fun nextRequestId(): Long

  /**
   * set the invocation [strategy] for a [requestId]
   */
  fun setStrategy(requestId: Long, strategy: InvocationStrategy<*>)

  /**
   * unset / remove the invocation strategy assigned to [requestId]
   */
  fun removeStrategy(requestId: Long)

  /**
   * writes a [JsonRPCRequest] [request] on the socket to the server
   * @returns future to indicate if the send was successful or not
   */
  fun send(request: JsonRPCRequest): Future<Unit>
}