/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.admin.impl;

import com.google.protobuf.Empty;
import io.axoniq.axonserver.connector.ResultStream;
import io.axoniq.axonserver.connector.admin.AdminChannel;
import io.axoniq.axonserver.connector.impl.AbstractAxonServerChannel;
import io.axoniq.axonserver.connector.impl.AbstractBufferedStream;
import io.axoniq.axonserver.connector.impl.AxonServerManagedChannel;
import io.axoniq.axonserver.connector.impl.FutureListStreamObserver;
import io.axoniq.axonserver.connector.impl.FutureStreamObserver;
import io.axoniq.axonserver.grpc.Component;
import io.axoniq.axonserver.grpc.FlowControl;
import io.axoniq.axonserver.grpc.admin.AdminActionResult;
import io.axoniq.axonserver.grpc.admin.ApplicationAdminServiceGrpc;
import io.axoniq.axonserver.grpc.admin.ApplicationId;
import io.axoniq.axonserver.grpc.admin.ApplicationOverview;
import io.axoniq.axonserver.grpc.admin.ApplicationRequest;
import io.axoniq.axonserver.grpc.admin.ContextAdminServiceGrpc;
import io.axoniq.axonserver.grpc.admin.ContextOverview;
import io.axoniq.axonserver.grpc.admin.ContextUpdate;
import io.axoniq.axonserver.grpc.admin.CreateContextRequest;
import io.axoniq.axonserver.grpc.admin.CreateOrUpdateUserRequest;
import io.axoniq.axonserver.grpc.admin.CreateReplicationGroupRequest;
import io.axoniq.axonserver.grpc.admin.DeleteContextRequest;
import io.axoniq.axonserver.grpc.admin.DeleteReplicationGroupRequest;
import io.axoniq.axonserver.grpc.admin.DeleteUserRequest;
import io.axoniq.axonserver.grpc.admin.EventProcessor;
import io.axoniq.axonserver.grpc.admin.EventProcessorAdminServiceGrpc;
import io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier;
import io.axoniq.axonserver.grpc.admin.GetContextRequest;
import io.axoniq.axonserver.grpc.admin.GetReplicationGroupRequest;
import io.axoniq.axonserver.grpc.admin.JoinReplicationGroup;
import io.axoniq.axonserver.grpc.admin.LeaveReplicationGroup;
import io.axoniq.axonserver.grpc.admin.LoadBalanceRequest;
import io.axoniq.axonserver.grpc.admin.LoadBalancingStrategy;
import io.axoniq.axonserver.grpc.admin.MoveSegment;
import io.axoniq.axonserver.grpc.admin.NodeOverview;
import io.axoniq.axonserver.grpc.admin.ReplicationGroupAdminServiceGrpc;
import io.axoniq.axonserver.grpc.admin.ReplicationGroupOverview;
import io.axoniq.axonserver.grpc.admin.Result;
import io.axoniq.axonserver.grpc.admin.Token;
import io.axoniq.axonserver.grpc.admin.UpdateContextPropertiesRequest;
import io.axoniq.axonserver.grpc.admin.UserAdminServiceGrpc;
import io.axoniq.axonserver.grpc.admin.UserOverview;
import io.axoniq.axonserver.grpc.control.ClientIdentification;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;

public class AdminChannelImpl
extends AbstractAxonServerChannel<Void>
implements AdminChannel {
    private static final int BUFFER_SIZE = 32;
    private static final int REFILL_BATCH = 8;
    private static final Empty EMPTY = Empty.getDefaultInstance();
    private final EventProcessorAdminServiceGrpc.EventProcessorAdminServiceStub eventProcessorServiceStub;
    private final ContextAdminServiceGrpc.ContextAdminServiceStub contextServiceStub;
    private final ReplicationGroupAdminServiceGrpc.ReplicationGroupAdminServiceStub replicationGroupServiceStub;
    private final ApplicationAdminServiceGrpc.ApplicationAdminServiceStub applicationServiceStub;
    private final UserAdminServiceGrpc.UserAdminServiceStub userServiceStub;

    public AdminChannelImpl(ClientIdentification clientIdentification, ScheduledExecutorService executor, AxonServerManagedChannel channel) {
        super(clientIdentification, executor, channel);
        this.eventProcessorServiceStub = EventProcessorAdminServiceGrpc.newStub((Channel)channel);
        this.contextServiceStub = ContextAdminServiceGrpc.newStub((Channel)channel);
        this.replicationGroupServiceStub = ReplicationGroupAdminServiceGrpc.newStub((Channel)channel);
        this.applicationServiceStub = ApplicationAdminServiceGrpc.newStub((Channel)channel);
        this.userServiceStub = UserAdminServiceGrpc.newStub((Channel)channel);
    }

    @Override
    public ResultStream<EventProcessor> eventProcessors() {
        AbstractBufferedStream<EventProcessor, Empty> results = new AbstractBufferedStream<EventProcessor, Empty>("", 32, 8){

            @Override
            protected Empty buildFlowControlMessage(FlowControl flowControl) {
                return null;
            }

            @Override
            protected EventProcessor terminalMessage() {
                return EventProcessor.newBuilder().build();
            }
        };
        this.eventProcessorServiceStub.getAllEventProcessors(EMPTY, (StreamObserver<EventProcessor>)results);
        return results;
    }

    @Override
    public ResultStream<EventProcessor> eventProcessorsByComponent(String component) {
        Component request = Component.newBuilder().setComponent(component).build();
        AbstractBufferedStream<EventProcessor, Empty> results = new AbstractBufferedStream<EventProcessor, Empty>("", 32, 8){

            @Override
            protected Empty buildFlowControlMessage(FlowControl flowControl) {
                return null;
            }

            @Override
            protected EventProcessor terminalMessage() {
                return EventProcessor.newBuilder().build();
            }
        };
        this.eventProcessorServiceStub.getEventProcessorsByComponent(request, (StreamObserver<EventProcessor>)results);
        return results;
    }

    @Override
    public CompletableFuture<Result> pauseEventProcessor(String eventProcessorName, String tokenStoreIdentifier) {
        EventProcessorIdentifier eventProcessorIdentifier = this.eventProcessorId(eventProcessorName, tokenStoreIdentifier);
        FutureStreamObserver<AdminActionResult> responseObserver = new FutureStreamObserver<AdminActionResult>(null);
        this.eventProcessorServiceStub.pauseEventProcessor(eventProcessorIdentifier, responseObserver);
        return responseObserver.thenApply(AdminActionResult::getResult);
    }

    @Override
    public CompletableFuture<Result> startEventProcessor(String eventProcessorName, String tokenStoreIdentifier) {
        EventProcessorIdentifier eventProcessorIdentifier = this.eventProcessorId(eventProcessorName, tokenStoreIdentifier);
        FutureStreamObserver<AdminActionResult> responseObserver = new FutureStreamObserver<AdminActionResult>(null);
        this.eventProcessorServiceStub.startEventProcessor(eventProcessorIdentifier, responseObserver);
        return responseObserver.thenApply(AdminActionResult::getResult);
    }

    @Override
    public CompletableFuture<Result> splitEventProcessor(String eventProcessorName, String tokenStoreIdentifier) {
        EventProcessorIdentifier eventProcessorIdentifier = this.eventProcessorId(eventProcessorName, tokenStoreIdentifier);
        FutureStreamObserver<AdminActionResult> responseObserver = new FutureStreamObserver<AdminActionResult>(null);
        this.eventProcessorServiceStub.splitEventProcessor(eventProcessorIdentifier, responseObserver);
        return responseObserver.thenApply(AdminActionResult::getResult);
    }

    @Override
    public CompletableFuture<Result> mergeEventProcessor(String eventProcessorName, String tokenStoreIdentifier) {
        EventProcessorIdentifier eventProcessorIdentifier = this.eventProcessorId(eventProcessorName, tokenStoreIdentifier);
        FutureStreamObserver<AdminActionResult> responseObserver = new FutureStreamObserver<AdminActionResult>(null);
        this.eventProcessorServiceStub.mergeEventProcessor(eventProcessorIdentifier, responseObserver);
        return responseObserver.thenApply(AdminActionResult::getResult);
    }

    @Override
    public CompletableFuture<Result> moveEventProcessorSegment(String eventProcessorName, String tokenStoreIdentifier, int segmentId, String targetClientIdentifier) {
        EventProcessorIdentifier eventProcessorIdentifier = this.eventProcessorId(eventProcessorName, tokenStoreIdentifier);
        FutureStreamObserver<AdminActionResult> responseObserver = new FutureStreamObserver<AdminActionResult>(null);
        MoveSegment request = MoveSegment.newBuilder().setEventProcessor(eventProcessorIdentifier).setSegment(segmentId).setTargetClientId(targetClientIdentifier).build();
        this.eventProcessorServiceStub.moveEventProcessorSegment(request, responseObserver);
        return responseObserver.thenApply(AdminActionResult::getResult);
    }

    @Override
    public CompletableFuture<Void> loadBalanceEventProcessor(String eventProcessorName, String tokenStoreIdentifier, String strategy) {
        EventProcessorIdentifier eventProcessorIdentifier = this.eventProcessorId(eventProcessorName, tokenStoreIdentifier);
        FutureStreamObserver<Empty> responseObserver = new FutureStreamObserver<Empty>(null);
        this.eventProcessorServiceStub.loadBalanceProcessor(LoadBalanceRequest.newBuilder().setProcessor(eventProcessorIdentifier).setStrategy(strategy).build(), responseObserver);
        return responseObserver.thenRun(() -> {});
    }

    @Override
    public CompletableFuture<Void> setAutoLoadBalanceStrategy(String eventProcessorName, String tokenStoreIdentifier, String strategy) {
        EventProcessorIdentifier eventProcessorIdentifier = this.eventProcessorId(eventProcessorName, tokenStoreIdentifier);
        FutureStreamObserver<Empty> responseObserver = new FutureStreamObserver<Empty>(null);
        this.eventProcessorServiceStub.setAutoLoadBalanceStrategy(LoadBalanceRequest.newBuilder().setProcessor(eventProcessorIdentifier).setStrategy(strategy).build(), responseObserver);
        return responseObserver.thenRun(() -> {});
    }

    @Override
    public CompletableFuture<List<LoadBalancingStrategy>> getBalancingStrategies() {
        FutureListStreamObserver<LoadBalancingStrategy> responseObserver = new FutureListStreamObserver<LoadBalancingStrategy>();
        this.eventProcessorServiceStub.getBalancingStrategies(Empty.newBuilder().build(), responseObserver);
        return responseObserver;
    }

    @Nonnull
    private EventProcessorIdentifier eventProcessorId(String eventProcessorName, String tokenStoreIdentifier) {
        return EventProcessorIdentifier.newBuilder().setProcessorName(eventProcessorName).setTokenStoreIdentifier(tokenStoreIdentifier).build();
    }

    @Override
    public CompletableFuture<Void> createOrUpdateUser(CreateOrUpdateUserRequest request) {
        FutureStreamObserver<Empty> responseObserver = new FutureStreamObserver<Empty>(null);
        this.userServiceStub.createOrUpdateUser(request, responseObserver);
        return responseObserver.thenAccept(empty -> {});
    }

    @Override
    public CompletableFuture<List<UserOverview>> getAllUsers() {
        FutureListStreamObserver<UserOverview> responseObserver = new FutureListStreamObserver<UserOverview>();
        this.userServiceStub.getUsers(Empty.newBuilder().build(), responseObserver);
        return responseObserver;
    }

    @Override
    public CompletableFuture<List<NodeOverview>> getAllNodes() {
        FutureListStreamObserver<NodeOverview> responseObserver = new FutureListStreamObserver<NodeOverview>();
        this.replicationGroupServiceStub.getNodes(Empty.newBuilder().build(), responseObserver);
        return responseObserver;
    }

    @Override
    public CompletableFuture<Void> deleteUser(String username) {
        FutureStreamObserver<Empty> responseObserver = new FutureStreamObserver<Empty>(null);
        this.userServiceStub.deleteUser(DeleteUserRequest.newBuilder().setUserName(username).build(), responseObserver);
        return responseObserver.thenAccept(empty -> {});
    }

    @Override
    public CompletableFuture<Token> createOrUpdateApplication(ApplicationRequest request) {
        FutureStreamObserver<Token> responseObserver = new FutureStreamObserver<Token>(null);
        this.applicationServiceStub.createOrUpdateApplication(request, responseObserver);
        return responseObserver;
    }

    @Override
    public CompletableFuture<List<ApplicationOverview>> getAllApplications() {
        FutureListStreamObserver<ApplicationOverview> responseObserver = new FutureListStreamObserver<ApplicationOverview>();
        this.applicationServiceStub.getApplications(Empty.newBuilder().build(), responseObserver);
        return responseObserver;
    }

    @Override
    public CompletableFuture<ApplicationOverview> getApplication(String applicationName) {
        FutureStreamObserver<ApplicationOverview> responseObserver = new FutureStreamObserver<ApplicationOverview>(null);
        this.applicationServiceStub.getApplication(ApplicationId.newBuilder().setApplicationName(applicationName).build(), responseObserver);
        return responseObserver;
    }

    @Override
    public CompletableFuture<Token> refreshToken(String applicationName) {
        FutureStreamObserver<Token> responseObserver = new FutureStreamObserver<Token>(null);
        this.applicationServiceStub.refreshToken(ApplicationId.newBuilder().setApplicationName(applicationName).build(), responseObserver);
        return responseObserver;
    }

    @Override
    public CompletableFuture<Void> deleteApplication(String applicationName) {
        FutureStreamObserver<Empty> responseObserver = new FutureStreamObserver<Empty>(null);
        this.applicationServiceStub.deleteApplication(ApplicationId.newBuilder().setApplicationName(applicationName).build(), responseObserver);
        return responseObserver.thenAccept(empty -> {});
    }

    @Override
    public CompletableFuture<Void> createContext(CreateContextRequest request) {
        FutureStreamObserver<Empty> responseObserver = new FutureStreamObserver<Empty>(null);
        this.contextServiceStub.createContext(request, responseObserver);
        return responseObserver.thenAccept(empty -> {});
    }

    @Override
    public CompletableFuture<Void> updateContextProperties(UpdateContextPropertiesRequest request) {
        FutureStreamObserver<Empty> responseObserver = new FutureStreamObserver<Empty>(null);
        this.contextServiceStub.updateContextProperties(request, responseObserver);
        return responseObserver.thenAccept(empty -> {});
    }

    @Override
    public CompletableFuture<Void> deleteContext(DeleteContextRequest request) {
        FutureStreamObserver<Empty> responseObserver = new FutureStreamObserver<Empty>(null);
        this.contextServiceStub.deleteContext(request, responseObserver);
        return responseObserver.thenAccept(empty -> {});
    }

    @Override
    public CompletableFuture<ContextOverview> getContextOverview(String context) {
        FutureStreamObserver<ContextOverview> responseObserver = new FutureStreamObserver<ContextOverview>(null);
        this.contextServiceStub.getContext(GetContextRequest.newBuilder().setName(context).build(), responseObserver);
        return responseObserver;
    }

    @Override
    public CompletableFuture<List<ContextOverview>> getAllContexts() {
        FutureListStreamObserver<ContextOverview> responseObserver = new FutureListStreamObserver<ContextOverview>();
        this.contextServiceStub.getContexts(Empty.newBuilder().build(), responseObserver);
        return responseObserver;
    }

    @Override
    public ResultStream<ContextUpdate> subscribeToContextUpdates() {
        AbstractBufferedStream<ContextUpdate, Empty> results = new AbstractBufferedStream<ContextUpdate, Empty>("", 32, 8){

            @Override
            protected Empty buildFlowControlMessage(FlowControl flowControl) {
                return null;
            }

            @Override
            protected ContextUpdate terminalMessage() {
                return ContextUpdate.newBuilder().build();
            }
        };
        this.contextServiceStub.subscribeContextUpdates(Empty.newBuilder().build(), (StreamObserver<ContextUpdate>)results);
        return results;
    }

    @Override
    public CompletableFuture<Void> addNodeToReplicationGroup(JoinReplicationGroup request) {
        FutureStreamObserver<Empty> responseObserver = new FutureStreamObserver<Empty>(null);
        this.replicationGroupServiceStub.addNodeToReplicationGroup(request, responseObserver);
        return responseObserver.thenAccept(empty -> {});
    }

    @Override
    public CompletableFuture<Void> createReplicationGroup(CreateReplicationGroupRequest request) {
        FutureStreamObserver<Empty> responseObserver = new FutureStreamObserver<Empty>(null);
        this.replicationGroupServiceStub.createReplicationGroup(request, responseObserver);
        return responseObserver.thenAccept(empty -> {});
    }

    @Override
    public CompletableFuture<Void> deleteReplicationGroup(DeleteReplicationGroupRequest request) {
        FutureStreamObserver<Empty> responseObserver = new FutureStreamObserver<Empty>(null);
        this.replicationGroupServiceStub.deleteReplicationGroup(request, responseObserver);
        return responseObserver.thenAccept(empty -> {});
    }

    @Override
    public CompletableFuture<ReplicationGroupOverview> getReplicationGroup(String replicationGroup) {
        FutureStreamObserver<ReplicationGroupOverview> responseObserver = new FutureStreamObserver<ReplicationGroupOverview>(null);
        this.replicationGroupServiceStub.getReplicationGroup(GetReplicationGroupRequest.newBuilder().setName(replicationGroup).build(), responseObserver);
        return responseObserver;
    }

    @Override
    public CompletableFuture<Void> removeNodeFromReplicationGroup(LeaveReplicationGroup request) {
        FutureStreamObserver<Empty> responseObserver = new FutureStreamObserver<Empty>(null);
        this.replicationGroupServiceStub.removeNodeFromReplicationGroup(request, responseObserver);
        return responseObserver.thenAccept(empty -> {});
    }

    @Override
    public CompletableFuture<List<ReplicationGroupOverview>> getAllReplicationGroups() {
        FutureListStreamObserver<ReplicationGroupOverview> responseObserver = new FutureListStreamObserver<ReplicationGroupOverview>();
        this.replicationGroupServiceStub.getReplicationGroups(Empty.newBuilder().build(), responseObserver);
        return responseObserver;
    }

    @Override
    public void connect() {
    }

    @Override
    public void reconnect() {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isReady() {
        return true;
    }
}

