/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.axoniq.axonserver.connector.AxonServerException;
import io.axoniq.axonserver.connector.ErrorCategory;
import io.axoniq.axonserver.connector.Registration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class AsyncRegistration
implements Registration {
    private final CompletableFuture<Void> requestAck;
    private final Supplier<CompletableFuture<Void>> cancelAction;

    public AsyncRegistration(CompletableFuture<Void> requestAck, Supplier<CompletableFuture<Void>> cancelAction) {
        this.requestAck = requestAck;
        this.cancelAction = cancelAction;
    }

    @Override
    public CompletableFuture<Void> cancel() {
        return this.cancelAction.get();
    }

    @Override
    public Registration awaitAck(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        try {
            this.requestAck.get(timeout, unit);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AxonServerException) {
                throw (AxonServerException)e.getCause();
            }
            throw new AxonServerException(ErrorCategory.INSTRUCTION_ACK_ERROR, "An instruction returned a failed acknowledgement", "", e);
        }
        return this;
    }

    @Override
    public Registration onAck(Runnable runnable) {
        this.requestAck.thenRun(runnable);
        return this;
    }
}

