/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector;

import io.axoniq.axonserver.connector.ErrorCategory;
import io.axoniq.axonserver.grpc.ErrorMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AxonServerException
extends RuntimeException {
    private final ErrorCategory errorCategory;
    private final String location;
    private final List<String> details;

    public AxonServerException(ErrorMessage errorMessage) {
        this(ErrorCategory.getFromCode(errorMessage.getErrorCode()), errorMessage.getMessage(), errorMessage.getLocation(), (List<String>)errorMessage.getDetailsList(), null);
    }

    public AxonServerException(ErrorCategory errorCategory, String message, String location) {
        this(errorCategory, message, location, Collections.emptyList(), null);
    }

    public AxonServerException(ErrorCategory errorCategory, String message, String location, Throwable cause) {
        this(errorCategory, message, location, Collections.emptyList(), cause);
    }

    public AxonServerException(ErrorCategory errorCategory, String message, String location, List<String> details, Throwable cause) {
        super("[" + errorCategory.errorCode() + "] " + message, cause);
        this.errorCategory = errorCategory;
        this.location = location;
        this.details = Collections.unmodifiableList(new ArrayList<String>(details));
    }

    public ErrorCategory getErrorCategory() {
        return this.errorCategory;
    }

    public List<String> getDetails() {
        return this.details;
    }

    public String getLocation() {
        return this.location;
    }
}

