/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.event.transformation.event.impl;

import io.axoniq.axonserver.connector.event.transformation.event.EventTransformationExecutor;
import io.axoniq.axonserver.connector.event.transformation.event.EventTransformer;
import io.axoniq.axonserver.connector.event.transformation.event.TransformableEventStream;
import io.axoniq.axonserver.connector.event.transformation.event.impl.IterableEventTransformationExecutor;
import io.axoniq.axonserver.grpc.event.EventWithToken;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

public class TransformableEventIterable
implements TransformableEventStream {
    private final Iterable<EventWithToken> events;

    public TransformableEventIterable(Iterable<EventWithToken> events) {
        this.events = events;
    }

    @Override
    public TransformableEventStream filter(final Predicate<EventWithToken> predicate) {
        return new TransformableEventIterable(() -> new Iterator<EventWithToken>(){
            private final Iterator<EventWithToken> iterator;
            private final AtomicReference<EventWithToken> next;
            {
                this.iterator = TransformableEventIterable.this.events.iterator();
                this.next = new AtomicReference();
                this.nextMatchingThePredicate().ifPresent(this.next::set);
            }

            @Override
            public boolean hasNext() {
                return this.next.get() != null;
            }

            @Override
            public EventWithToken next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                EventWithToken current = this.next.get();
                this.next.set(this.nextMatchingThePredicate().orElse(null));
                return current;
            }

            private Optional<EventWithToken> nextMatchingThePredicate() {
                while (this.iterator.hasNext()) {
                    EventWithToken current = this.iterator.next();
                    if (!predicate.test(current)) continue;
                    return Optional.of(current);
                }
                return Optional.empty();
            }
        });
    }

    @Override
    public EventTransformationExecutor transform(String transformationDescription, EventTransformer eventTransformer) {
        return new IterableEventTransformationExecutor(transformationDescription, this.events, eventTransformer);
    }
}

