/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.axoniq.axonserver.connector.AxonServerException;
import io.axoniq.axonserver.connector.ErrorCategory;
import io.axoniq.axonserver.connector.ReplyChannel;
import io.axoniq.axonserver.connector.impl.HeartbeatSender;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatMonitor {
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatMonitor.class);
    private static final PlatformInboundInstruction HEARTBEAT_MESSAGE = PlatformInboundInstruction.newBuilder().setHeartbeat(Heartbeat.getDefaultInstance()).build();
    static Clock clock = Clock.systemUTC();
    private final ScheduledExecutorService executor;
    private final HeartbeatSender sender;
    private final Runnable onConnectionCorrupted;
    private final AtomicLong nextHeartbeatDeadline = new AtomicLong();
    private final AtomicLong nextHeartbeat = new AtomicLong();
    private final AtomicLong timeout = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong interval = new AtomicLong(Long.MAX_VALUE);
    private final AtomicInteger taskId = new AtomicInteger();

    public HeartbeatMonitor(ScheduledExecutorService executor, HeartbeatSender heartbeatSender, Runnable onConnectionCorrupted) {
        this.executor = executor;
        this.sender = heartbeatSender;
        this.onConnectionCorrupted = onConnectionCorrupted;
    }

    public void enableHeartbeat(long interval, long timeout, TimeUnit timeUnit) {
        this.interval.set(timeUnit.toMillis(interval));
        this.timeout.set(timeUnit.toMillis(timeout));
        long now = clock.millis();
        this.nextHeartbeat.set(now);
        this.nextHeartbeatDeadline.set(now + timeUnit.toMillis(timeout));
        int task = this.taskId.incrementAndGet();
        this.executor.execute(() -> this.checkAndReschedule(task));
    }

    public void disableHeartbeat() {
        this.interval.set(Long.MAX_VALUE);
        this.nextHeartbeatDeadline.set(Long.MAX_VALUE);
        this.taskId.incrementAndGet();
    }

    private void checkAndReschedule(int task) {
        if (task != this.taskId.get()) {
            return;
        }
        this.checkBeatDeadline();
        this.sendBeatIfTimeElapsed();
        long delay = Math.min(this.interval.get(), 1000L);
        this.debug("Scheduling next heartbeat verification in {}ms", delay);
        this.executor.schedule(() -> this.checkAndReschedule(task), delay, TimeUnit.MILLISECONDS);
    }

    public void pause() {
        long currentInterval = this.interval.get();
        long currentTimeout = this.timeout.get();
        if (currentInterval != Long.MAX_VALUE || currentTimeout != Long.MAX_VALUE) {
            this.taskId.incrementAndGet();
        }
    }

    public void resume() {
        long currentInterval = this.interval.get();
        long currentTimeout = this.timeout.get();
        if (currentInterval != Long.MAX_VALUE && currentTimeout != Long.MAX_VALUE) {
            this.enableHeartbeat(currentInterval, currentTimeout, TimeUnit.MILLISECONDS);
        }
    }

    private void sendBeatIfTimeElapsed() {
        if (!this.shouldSendBeat()) {
            return;
        }
        this.debug("Sending heartbeat due to elapsed next beat interval.", new Object[0]);
        try {
            this.sender.sendHeartbeat().whenComplete((r, e) -> this.handleHeartbeatCallResult((Throwable)e));
            Instant newNextHeartbeatTime = this.extendNextHeartbeatTime();
            this.debug("Next heartbeat has been planned for {} due to sent heartbeat", newNextHeartbeatTime);
        }
        catch (Exception e2) {
            logger.warn("Was unable to send heartbeat due to exception", (Throwable)e2);
        }
    }

    private void debug(String message, Object ... args) {
        if (logger.isDebugEnabled()) {
            logger.debug(message, args);
        }
    }

    private void checkBeatDeadline() {
        long now = clock.millis();
        long nextDeadline = this.nextHeartbeatDeadline.get();
        if (nextDeadline <= now) {
            logger.info("Did not receive heartbeat acknowledgement within {}ms", (Object)this.timeout.get());
            this.onConnectionCorrupted.run();
            this.extendHeartbeatDeadline();
        }
    }

    private void handleHeartbeatCallResult(Throwable e) {
        boolean heartbeatsDisabled;
        boolean success;
        boolean bl = success = e == null || this.isUnsupportedInstructionError(e);
        if (!success) {
            this.debug("Heartbeat call resulted in an error.", e);
            this.onConnectionCorrupted.run();
            return;
        }
        boolean bl2 = heartbeatsDisabled = this.interval.get() == Long.MAX_VALUE;
        if (heartbeatsDisabled) {
            this.debug("Heartbeat Acknowledgment received but heartbeats were disabled.", new Object[0]);
            return;
        }
        Instant extendedDeadline = this.extendHeartbeatDeadline();
        this.debug("Heartbeat call succeeded and extended deadline to {}", extendedDeadline);
    }

    private boolean isUnsupportedInstructionError(Throwable e) {
        return e instanceof AxonServerException && ((AxonServerException)e).getErrorCategory() == ErrorCategory.UNSUPPORTED_INSTRUCTION;
    }

    private boolean shouldSendBeat() {
        long now = clock.millis();
        return this.nextHeartbeat.get() <= now;
    }

    private Instant extendNextHeartbeatTime() {
        long now = clock.millis();
        long newNextHeartbeat = this.nextHeartbeat.updateAndGet(current -> now + this.interval.get());
        return Instant.ofEpochMilli(newNextHeartbeat);
    }

    private Instant extendHeartbeatDeadline() {
        long now = clock.millis();
        long newDeadline = this.nextHeartbeatDeadline.updateAndGet(currentDeadline -> Math.max(now + this.timeout.get() + this.interval.get(), currentDeadline));
        return Instant.ofEpochMilli(newDeadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIncomingBeat(ReplyChannel<PlatformInboundInstruction> reply) {
        Instant newHeartbeatTime = this.extendNextHeartbeatTime();
        Instant extendedDeadline = this.extendHeartbeatDeadline();
        this.debug("Received heartbeat call from server, extending deadline to {} and planned next heartbeat for {}", extendedDeadline, newHeartbeatTime);
        try {
            reply.send(HEARTBEAT_MESSAGE);
        }
        finally {
            reply.complete();
        }
    }
}

