/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector;

import java.util.Arrays;

public enum ErrorCategory {
    AUTHENTICATION_TOKEN_MISSING("AXONIQ-1000"),
    AUTHENTICATION_INVALID_TOKEN("AXONIQ-1001"),
    UNSUPPORTED_INSTRUCTION("AXONIQ-1002"),
    INSTRUCTION_ACK_ERROR("AXONIQ-1003"),
    INSTRUCTION_EXECUTION_ERROR("AXONIQ-1004"),
    INVALID_EVENT_SEQUENCE("AXONIQ-2000"),
    NO_EVENT_STORE_MASTER_AVAILABLE("AXONIQ-2100"),
    EVENT_PAYLOAD_TOO_LARGE("AXONIQ-2001"),
    CONNECTION_FAILED("AXONIQ-3001"),
    GRPC_MESSAGE_TOO_LARGE("AXONIQ-3002"),
    NO_HANDLER_FOR_COMMAND("AXONIQ-4000"),
    COMMAND_EXECUTION_ERROR("AXONIQ-4002"),
    COMMAND_DISPATCH_ERROR("AXONIQ-4003"),
    CONCURRENCY_EXCEPTION("AXONIQ-4004"),
    NO_HANDLER_FOR_QUERY("AXONIQ-5000"),
    QUERY_EXECUTION_ERROR("AXONIQ-5001"),
    QUERY_DISPATCH_ERROR("AXONIQ-5002"),
    DATAFILE_READ_ERROR("AXONIQ-9000"),
    INDEX_READ_ERROR("AXONIQ-9001"),
    DATAFILE_WRITE_ERROR("AXONIQ-9100"),
    INDEX_WRITE_ERROR("AXONIQ-9101"),
    DIRECTORY_CREATION_FAILED("AXONIQ-9102"),
    VALIDATION_FAILED("AXONIQ-9200"),
    TRANSACTION_ROLLED_BACK("AXONIQ-9900"),
    OTHER("AXONIQ-0001");

    private final String errorCode;

    private ErrorCategory(String errorCode) {
        this.errorCode = errorCode;
    }

    public static ErrorCategory getFromCode(String code) {
        return Arrays.stream(ErrorCategory.values()).filter(value -> value.errorCode.equals(code)).findFirst().orElse(OTHER);
    }

    public String errorCode() {
        return this.errorCode;
    }
}

