/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.secretsmanager;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import io.awspring.cloud.autoconfigure.secretsmanager.AwsSecretsManagerBootstrapConfiguration;
import io.awspring.cloud.autoconfigure.secretsmanager.AwsSecretsManagerConfigDataResource;
import io.awspring.cloud.secretsmanager.AwsSecretsManagerProperties;
import io.awspring.cloud.secretsmanager.AwsSecretsManagerPropertySources;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

public class AwsSecretsManagerConfigDataLocationResolver
implements ConfigDataLocationResolver<AwsSecretsManagerConfigDataResource> {
    private final Log log;
    public static final String PREFIX = "aws-secretsmanager:";

    public AwsSecretsManagerConfigDataLocationResolver(Log log) {
        this.log = log;
    }

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        if (!location.hasPrefix(PREFIX)) {
            return false;
        }
        return (Boolean)context.getBinder().bind("aws.secretsmanager.enabled", Boolean.class).orElse((Object)true);
    }

    public List<AwsSecretsManagerConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException {
        return Collections.emptyList();
    }

    public List<AwsSecretsManagerConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        this.registerBean(resolverContext, AwsSecretsManagerProperties.class, this.loadProperties(resolverContext.getBinder()));
        this.registerAndPromoteBean(resolverContext, AWSSecretsManager.class, this::createAwsSecretsManagerClient);
        AwsSecretsManagerProperties properties = this.loadConfigProperties(resolverContext.getBinder());
        AwsSecretsManagerPropertySources propertySources = new AwsSecretsManagerPropertySources(properties, this.log);
        List<String> contexts = location.getValue().equals(PREFIX) ? propertySources.getAutomaticContexts(profiles.getAccepted()) : this.getCustomContexts(location.getNonPrefixedValue(PREFIX));
        ArrayList<AwsSecretsManagerConfigDataResource> locations = new ArrayList<AwsSecretsManagerConfigDataResource>();
        contexts.forEach(propertySourceContext -> locations.add(new AwsSecretsManagerConfigDataResource((String)propertySourceContext, location.isOptional(), propertySources)));
        return locations;
    }

    private List<String> getCustomContexts(String keys) {
        if (StringUtils.hasLength((String)keys)) {
            return Arrays.asList(keys.split(";"));
        }
        return Collections.emptyList();
    }

    protected <T> void registerAndPromoteBean(ConfigDataLocationResolverContext context, Class<T> type, BootstrapRegistry.InstanceSupplier<T> supplier) {
        this.registerBean(context, type, supplier);
        context.getBootstrapContext().addCloseListener(event -> {
            Object instance = event.getBootstrapContext().get(type);
            String name = "configData" + type.getSimpleName();
            ConfigurableApplicationContext appContext = event.getApplicationContext();
            if (!appContext.getBeanFactory().containsBean(name)) {
                appContext.getBeanFactory().registerSingleton(name, instance);
            }
        });
    }

    public <T> void registerBean(ConfigDataLocationResolverContext context, Class<T> type, T instance) {
        context.getBootstrapContext().registerIfAbsent(type, BootstrapRegistry.InstanceSupplier.of(instance));
    }

    protected <T> void registerBean(ConfigDataLocationResolverContext context, Class<T> type, BootstrapRegistry.InstanceSupplier<T> supplier) {
        ConfigurableBootstrapContext bootstrapContext = context.getBootstrapContext();
        bootstrapContext.registerIfAbsent(type, supplier);
    }

    protected AWSSecretsManager createAwsSecretsManagerClient(BootstrapContext context) {
        AwsSecretsManagerProperties properties = (AwsSecretsManagerProperties)context.get(AwsSecretsManagerProperties.class);
        return AwsSecretsManagerBootstrapConfiguration.createSecretsManagerClient(properties);
    }

    protected AwsSecretsManagerProperties loadProperties(Binder binder) {
        return (AwsSecretsManagerProperties)binder.bind("aws.secretsmanager", Bindable.of(AwsSecretsManagerProperties.class)).orElseGet(AwsSecretsManagerProperties::new);
    }

    protected AwsSecretsManagerProperties loadConfigProperties(Binder binder) {
        AwsSecretsManagerProperties properties = (AwsSecretsManagerProperties)binder.bind("aws.secretsmanager", Bindable.of(AwsSecretsManagerProperties.class)).orElseGet(AwsSecretsManagerProperties::new);
        if (!StringUtils.hasLength((String)properties.getName())) {
            properties.setName((String)binder.bind("spring.application.name", String.class).orElse((Object)"application"));
        }
        return properties;
    }
}

