/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.secretsmanager;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import io.awspring.cloud.autoconfigure.secretsmanager.AwsSecretsManagerConfigDataResource;
import io.awspring.cloud.secretsmanager.AwsSecretsManagerPropertySource;
import java.util.Collections;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;

public class AwsSecretsManagerConfigDataLoader
implements ConfigDataLoader<AwsSecretsManagerConfigDataResource> {
    public ConfigData load(ConfigDataLoaderContext context, AwsSecretsManagerConfigDataResource resource) {
        try {
            AWSSecretsManager sm = (AWSSecretsManager)context.getBootstrapContext().get(AWSSecretsManager.class);
            AwsSecretsManagerPropertySource propertySource = resource.getPropertySources().createPropertySource(resource.getContext(), resource.isOptional(), sm);
            if (propertySource != null) {
                return new ConfigData(Collections.singletonList(propertySource), new ConfigData.Option[0]);
            }
            return null;
        }
        catch (Exception e) {
            throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
        }
    }
}

