/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.paramstore;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import com.amazonaws.util.StringUtils;
import io.awspring.cloud.core.SpringCloudClientConfiguration;
import io.awspring.cloud.paramstore.AwsParamStoreProperties;
import io.awspring.cloud.paramstore.AwsParamStorePropertySourceLocator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={AwsParamStoreProperties.class})
@ConditionalOnClass(value={AWSSimpleSystemsManagement.class, AwsParamStorePropertySourceLocator.class})
@ConditionalOnProperty(prefix="aws.paramstore", name={"enabled"}, matchIfMissing=true)
public class AwsParamStoreBootstrapConfiguration {
    private final Environment environment;

    public AwsParamStoreBootstrapConfiguration(Environment environment) {
        this.environment = environment;
    }

    @Bean
    AwsParamStorePropertySourceLocator awsParamStorePropertySourceLocator(AWSSimpleSystemsManagement ssmClient, AwsParamStoreProperties properties) {
        if (StringUtils.isNullOrEmpty((String)properties.getName())) {
            properties.setName(this.environment.getProperty("spring.application.name"));
        }
        return new AwsParamStorePropertySourceLocator(ssmClient, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    AWSSimpleSystemsManagement ssmClient(AwsParamStoreProperties properties) {
        return AwsParamStoreBootstrapConfiguration.createSimpleSystemManagementClient(properties);
    }

    public static AWSSimpleSystemsManagement createSimpleSystemManagementClient(AwsParamStoreProperties properties) {
        AWSSimpleSystemsManagementClientBuilder builder = (AWSSimpleSystemsManagementClientBuilder)AWSSimpleSystemsManagementClientBuilder.standard().withClientConfiguration(SpringCloudClientConfiguration.getClientConfiguration());
        if (!StringUtils.isNullOrEmpty((String)properties.getRegion())) {
            builder.withRegion(properties.getRegion());
        }
        if (properties.getEndpoint() != null) {
            AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(properties.getEndpoint().toString(), null);
            builder.withEndpointConfiguration(endpointConfiguration);
        }
        return (AWSSimpleSystemsManagement)builder.build();
    }
}

