/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.backpressure;

import io.awspring.cloud.sqs.listener.IdentifiableContainerComponent;
import io.awspring.cloud.sqs.listener.backpressure.BackPressureHandler;
import io.awspring.cloud.sqs.listener.backpressure.BatchAwareBackPressureHandler;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class FullBatchBackPressureHandler
implements BatchAwareBackPressureHandler,
IdentifiableContainerComponent {
    private static final Logger logger = LoggerFactory.getLogger(FullBatchBackPressureHandler.class);
    private final int batchSize;
    private String id = this.getClass().getSimpleName();

    private FullBatchBackPressureHandler(Builder builder) {
        this.batchSize = builder.batchSize;
        logger.debug("FullBatchBackPressureHandler created with configuration: batchSize: {}", (Object)this.batchSize);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int requestBatch() throws InterruptedException {
        return this.request(this.batchSize);
    }

    @Override
    public int request(int amount) throws InterruptedException {
        if (amount == this.batchSize) {
            return amount;
        }
        logger.warn("[{}] Could not acquire a full batch ({} / {}), cancelling current poll", new Object[]{this.id, amount, this.batchSize});
        return 0;
    }

    @Override
    public void release(int amount, BackPressureHandler.ReleaseReason reason) {
    }

    @Override
    public boolean drain(Duration timeout) {
        return true;
    }

    public static class Builder {
        private int batchSize;

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public FullBatchBackPressureHandler build() {
            Assert.notNull((Object)this.batchSize, (String)"Missing configuration for batch size");
            Assert.isTrue((this.batchSize > 0 ? 1 : 0) != 0, (String)"The batch size must be greater than 0");
            return new FullBatchBackPressureHandler(this);
        }
    }
}

