/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.integration;

import io.awspring.cloud.sqs.operations.SqsAsyncOperations;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class SqsMessageHandler
extends AbstractMessageProducingHandler {
    public static final long DEFAULT_SEND_TIMEOUT = 10000L;
    private final SqsAsyncOperations sqsAsyncOperations;
    private Expression queueExpression;
    private EvaluationContext evaluationContext;
    private Expression sendTimeoutExpression = new ValueExpression((Object)10000L);

    public SqsMessageHandler(SqsAsyncOperations sqsAsyncOperations) {
        this.sqsAsyncOperations = sqsAsyncOperations;
    }

    public void setQueue(String queue) {
        this.setQueueExpression((Expression)new LiteralExpression(queue));
    }

    public void setQueueExpressionString(String queueExpression) {
        this.setQueueExpression(EXPRESSION_PARSER.parseExpression(queueExpression));
    }

    public void setQueueExpression(Expression queueExpression) {
        this.queueExpression = queueExpression;
    }

    public void setSendTimeout(long sendTimeout) {
        this.setSendTimeoutExpression((Expression)new ValueExpression((Object)sendTimeout));
    }

    public void setSendTimeoutExpressionString(String sendTimeoutExpression) {
        this.setSendTimeoutExpression(EXPRESSION_PARSER.parseExpression(sendTimeoutExpression));
    }

    public void setSendTimeoutExpression(Expression sendTimeoutExpression) {
        Assert.notNull((Object)sendTimeoutExpression, (String)"'sendTimeoutExpression' must not be null");
        this.sendTimeoutExpression = sendTimeoutExpression;
    }

    protected void onInit() {
        Assert.notNull((Object)this.queueExpression, (String)"The SQS queue must be provided.");
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected boolean shouldCopyRequestHeaders() {
        return false;
    }

    protected void handleMessageInternal(Message<?> message) {
        CompletionStage resultFuture;
        String queueName = (String)this.queueExpression.getValue(this.evaluationContext, message, String.class);
        Assert.hasText((String)queueName, (String)"The 'queueExpression' must not evaluate to empty String.");
        Object object = message.getPayload();
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Assert.notEmpty((Collection)collection, (String)"The payload with a collection of messages must not be empty.");
            Object next = collection.iterator().next();
            Assert.isInstanceOf(Message.class, next, (String)"The payload with a collection of messages must contain 'Message' instances only.");
            Collection messages = collection;
            resultFuture = this.sqsAsyncOperations.sendManyAsync(queueName, messages).thenApply(batchResult -> this.getMessageBuilderFactory().withPayload(batchResult).build());
        } else {
            resultFuture = this.sqsAsyncOperations.sendAsync(queueName, message).thenApply(sendResult -> this.getMessageBuilderFactory().fromMessage(sendResult.message()).setHeader("Sqs_QueueName", (Object)sendResult.endpoint()).setHeader("Sqs_Msa_messageId", (Object)sendResult.messageId()).copyHeaders(sendResult.additionalInformation()).build());
        }
        if (this.isAsync()) {
            this.sendOutputs(resultFuture, message);
            return;
        }
        Long sendTimeout = (Long)this.sendTimeoutExpression.getValue(this.evaluationContext, message, Long.class);
        if (sendTimeout == null || sendTimeout < 0L) {
            try {
                ((CompletableFuture)resultFuture).get();
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new IllegalStateException(ex);
            }
        }
        try {
            ((CompletableFuture)resultFuture).get(sendTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            throw new MessageTimeoutException(message, "Timeout waiting for response from Amazon SQS", (Throwable)te);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
        catch (ExecutionException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

