/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.sqs.support.converter.SnsJsonNode;
import java.util.List;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SnsSubjectConverter
implements MessageConverter {
    private final ObjectMapper objectMapper;

    public SnsSubjectConverter(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"jsonMapper must not be null");
        this.objectMapper = objectMapper;
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        Assert.notNull(message, (String)"message must not be null");
        Assert.notNull(targetClass, (String)"target class must not be null");
        Object payload = message.getPayload();
        if (!ClassUtils.isAssignable(targetClass, String.class)) {
            throw new MessageConversionException("Subject can only be injected into String assignable Types", null);
        }
        if (payload instanceof List) {
            throw new MessageConversionException("Conversion of List is not supported", null);
        }
        SnsJsonNode snsJsonNode = new SnsJsonNode(this.objectMapper, message.getPayload().toString());
        return snsJsonNode.getSubjectAsString();
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        throw new UnsupportedOperationException("This converter only supports reading a SNS notification and not writing them");
    }
}

