/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.errorhandler;

import java.util.Random;
import java.util.function.Supplier;
import org.springframework.util.Assert;

public interface Jitter {
    public static final Jitter NONE = Context::getTimeout;
    public static final Jitter FULL = context -> Math.max(1, context.getRandomSupplier().get().nextInt(context.getTimeout() + 1));
    public static final Jitter HALF = context -> {
        int timeout = context.getTimeout();
        int lowerBound = Math.max(1, (int)Math.ceil((double)timeout / 2.0));
        return context.getRandomSupplier().get().nextInt(lowerBound, timeout + 1);
    };

    public int applyJitter(Context var1);

    public static class Context {
        private final int timeout;
        private final Supplier<Random> randomSupplier;

        public Context(int timeout, Supplier<Random> randomSupplier) {
            Assert.isTrue((timeout >= 1 ? 1 : 0) != 0, () -> "Timeout must be >= 1, but was " + timeout);
            Assert.notNull(randomSupplier, (String)"Random supplier cannot be null");
            this.timeout = timeout;
            this.randomSupplier = randomSupplier;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public Supplier<Random> getRandomSupplier() {
            return this.randomSupplier;
        }
    }
}

