/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.annotation;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.sqs.annotation.AbstractListenerAnnotationBeanPostProcessor;
import io.awspring.cloud.sqs.annotation.SqsHandler;
import io.awspring.cloud.sqs.annotation.SqsListener;
import io.awspring.cloud.sqs.config.Endpoint;
import io.awspring.cloud.sqs.config.MultiMethodSqsEndpoint;
import io.awspring.cloud.sqs.config.SqsEndpoint;
import io.awspring.cloud.sqs.support.resolver.BatchVisibilityHandlerMethodArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.NotificationMessageArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.NotificationSubjectArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.QueueAttributesMethodArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.SnsNotificationArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.SqsMessageMethodArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.VisibilityHandlerMethodArgumentResolver;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;

public class SqsListenerAnnotationBeanPostProcessor
extends AbstractListenerAnnotationBeanPostProcessor<SqsListener> {
    private static final String GENERATED_ID_PREFIX = "io.awspring.cloud.sqs.sqsListenerEndpointContainer#";

    @Override
    protected Class<SqsListener> getAnnotationClass() {
        return SqsListener.class;
    }

    @Override
    protected Endpoint createEndpoint(SqsListener sqsListenerAnnotation) {
        return SqsEndpoint.builder().queueNames(this.resolveEndpointNames(sqsListenerAnnotation.value())).factoryBeanName(this.resolveAsString(sqsListenerAnnotation.factory(), "factory")).id(this.getEndpointId(sqsListenerAnnotation.id())).pollTimeoutSeconds(this.resolveAsInteger(sqsListenerAnnotation.pollTimeoutSeconds(), "pollTimeoutSeconds")).maxMessagesPerPoll(this.resolveAsInteger(sqsListenerAnnotation.maxMessagesPerPoll(), "maxMessagesPerPoll")).maxConcurrentMessages(this.resolveAsInteger(sqsListenerAnnotation.maxConcurrentMessages(), "maxConcurrentMessages")).messageVisibility(this.resolveAsInteger(sqsListenerAnnotation.messageVisibilitySeconds(), "messageVisibility")).acknowledgementMode(this.resolveAcknowledgement(sqsListenerAnnotation.acknowledgementMode())).build();
    }

    @Override
    protected Endpoint createMultiMethodEndpoint(SqsListener sqsListenerAnnotation, List<Method> methods, @Nullable Method defaultMethod, Object bean) {
        return MultiMethodSqsEndpoint.builder().factoryBeanName(this.resolveAsString(sqsListenerAnnotation.factory(), "factory")).queueNames(this.resolveEndpointNames(sqsListenerAnnotation.value())).bean(bean).methods(methods).defaultMethod(defaultMethod).id(this.getEndpointId(sqsListenerAnnotation.id())).sqsEndpoint(this.createEndpoint(sqsListenerAnnotation)).build();
    }

    @Override
    protected Set<Method> getHandlerMethods(Class<?> targetClass) {
        return MethodIntrospector.selectMethods(targetClass, method -> AnnotationUtils.findAnnotation((Method)method, SqsHandler.class) != null);
    }

    @Override
    protected String getGeneratedIdPrefix() {
        return GENERATED_ID_PREFIX;
    }

    @Override
    protected String getMessageListenerContainerRegistryBeanName() {
        return "io.awspring.cloud.messaging.internalEndpointRegistryBeanName";
    }

    @Override
    protected Collection<HandlerMethodArgumentResolver> createAdditionalArgumentResolvers() {
        return Arrays.asList(new VisibilityHandlerMethodArgumentResolver("Sqs_VisibilityTimeout"), new BatchVisibilityHandlerMethodArgumentResolver("Sqs_VisibilityTimeout"), new SqsMessageMethodArgumentResolver(), new QueueAttributesMethodArgumentResolver());
    }

    @Override
    protected Collection<HandlerMethodArgumentResolver> createAdditionalArgumentResolvers(MessageConverter messageConverter, ObjectMapper objectMapper) {
        ArrayList<HandlerMethodArgumentResolver> argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>(this.createAdditionalArgumentResolvers());
        if (objectMapper != null) {
            argumentResolvers.add(new NotificationMessageArgumentResolver(messageConverter, objectMapper));
            argumentResolvers.add(new NotificationSubjectArgumentResolver(objectMapper));
            argumentResolvers.add(new SnsNotificationArgumentResolver(messageConverter, objectMapper));
        }
        return argumentResolvers;
    }

    @Override
    protected Method getDefaultHandlerMethod(Class<?> targetClass, List<Method> handlerMethods) {
        Method defaultMethod = null;
        for (Method method : handlerMethods) {
            SqsHandler annotation = method.getAnnotation(SqsHandler.class);
            if (!annotation.isDefault()) continue;
            if (defaultMethod != null) {
                throw new IllegalArgumentException("There is more than one default method for the same listener in class: " + targetClass);
            }
            defaultMethod = method;
        }
        return defaultMethod;
    }
}

