/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;

public class QueueAttributes {
    private final String queueName;
    private final String queueUrl;
    private final Map<QueueAttributeName, String> attributes;

    public QueueAttributes(String queueName, String queueUrl, Map<QueueAttributeName, String> attributes) {
        Assert.notNull((Object)queueName, (String)"queueName cannot be null");
        Assert.notNull((Object)queueUrl, (String)"queueUrl cannot be null");
        Assert.notNull(attributes, (String)"attributes cannot be null");
        this.queueName = queueName;
        this.queueUrl = queueUrl;
        this.attributes = attributes;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public Map<QueueAttributeName, String> getQueueAttributes() {
        return new HashMap<QueueAttributeName, String>(this.attributes);
    }

    @Nullable
    public String getQueueAttribute(QueueAttributeName queueAttributeName) {
        return this.attributes.get(queueAttributeName);
    }
}

