/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.config;

import io.awspring.cloud.sqs.config.HandlerMethodEndpoint;
import io.awspring.cloud.sqs.listener.AsyncMessageListener;
import io.awspring.cloud.sqs.listener.BatchVisibility;
import io.awspring.cloud.sqs.listener.ListenerMode;
import io.awspring.cloud.sqs.listener.MessageListener;
import io.awspring.cloud.sqs.listener.MessageListenerContainer;
import io.awspring.cloud.sqs.listener.acknowledgement.BatchAcknowledgement;
import io.awspring.cloud.sqs.listener.adapter.AsyncMessagingMessageListenerAdapter;
import io.awspring.cloud.sqs.listener.adapter.MessagingMessageListenerAdapter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;

public abstract class AbstractEndpoint
implements HandlerMethodEndpoint {
    private final Collection<String> logicalNames;
    private final String listenerContainerFactoryName;
    private final String id;
    private Object bean;
    private Method method;
    private MessageHandlerMethodFactory handlerMethodFactory;

    protected AbstractEndpoint(Collection<String> queueNames, @Nullable String listenerContainerFactoryName, String id) {
        Assert.notEmpty(queueNames, (String)"queueNames cannot be empty.");
        this.id = id;
        this.logicalNames = queueNames;
        this.listenerContainerFactoryName = listenerContainerFactoryName;
    }

    @Override
    public Collection<String> getLogicalNames() {
        return this.logicalNames;
    }

    @Override
    public String getListenerContainerFactoryName() {
        return this.listenerContainerFactoryName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setBean(Object bean) {
        this.bean = bean;
    }

    @Override
    public void setMethod(Method method) {
        this.method = method;
    }

    @Override
    public void setHandlerMethodFactory(MessageHandlerMethodFactory handlerMethodFactory) {
        Assert.notNull((Object)handlerMethodFactory, (String)"handlerMethodFactory cannot be null");
        this.handlerMethodFactory = handlerMethodFactory;
    }

    @Override
    public void configureListenerMode(Consumer<ListenerMode> consumer) {
        List<MethodParameter> parameters = this.getMethodParameters();
        boolean batch = this.hasParameterOfType(parameters, List.class);
        boolean batchAckParameter = this.hasParameterOfType(parameters, BatchAcknowledgement.class);
        boolean batchVisibilityParameter = this.hasParameterOfType(parameters, BatchVisibility.class);
        Assert.isTrue((boolean)this.hasValidParameters(batch, batchAckParameter, batchVisibilityParameter, parameters.size()), (String)this.getInvalidParametersMessage());
        consumer.accept(batch ? ListenerMode.BATCH : ListenerMode.SINGLE_MESSAGE);
    }

    private boolean hasValidParameters(boolean batch, boolean batchAckParameter, boolean batchVisibilityParameter, int size) {
        return this.hasValidSingleMessageParameters(batch, batchAckParameter, batchVisibilityParameter) || this.hasValidBatchParameters(batchAckParameter, batchVisibilityParameter, size);
    }

    private boolean hasValidSingleMessageParameters(boolean batch, boolean batchAckParameter, boolean batchVisibilityParameter) {
        return !batch && !batchAckParameter && !batchVisibilityParameter;
    }

    private boolean hasValidBatchParameters(boolean batchAckParameter, boolean batchVisibilityParameter, int size) {
        long expectedAdditionalParams = Stream.of(batchAckParameter, batchVisibilityParameter).filter(b -> b).count();
        return (long)size == expectedAdditionalParams + 1L;
    }

    private String getInvalidParametersMessage() {
        return String.format("Method %s from class %s in endpoint %s has invalid parameters for batch processing. Batch methods must have a single List parameter, either of Message<T> or T types,and optionally BatchAcknowledgement and BatchVisibility parameters.", this.method.getName(), this.method.getDeclaringClass(), this.id);
    }

    private boolean hasParameterOfType(List<MethodParameter> parameters, Class<?> clazz) {
        return parameters.stream().anyMatch(param -> clazz.isAssignableFrom(param.getParameterType()));
    }

    private List<MethodParameter> getMethodParameters() {
        return IntStream.range(0, BridgeMethodResolver.findBridgedMethod((Method)this.method).getParameterCount()).mapToObj(index -> new MethodParameter(this.method, index)).collect(Collectors.toList());
    }

    @Override
    public <T> void setupContainer(MessageListenerContainer<T> container) {
        Assert.notNull((Object)this.handlerMethodFactory, (String)"No handlerMethodFactory has been set");
        InvocableHandlerMethod handlerMethod = this.handlerMethodFactory.createInvocableHandlerMethod(this.bean, this.method);
        if (CompletionStage.class.isAssignableFrom(handlerMethod.getReturnType().getParameterType())) {
            container.setAsyncMessageListener(this.createAsyncMessageListenerInstance(handlerMethod));
        } else {
            container.setMessageListener(this.createMessageListenerInstance(handlerMethod));
        }
    }

    protected <T> MessageListener<T> createMessageListenerInstance(InvocableHandlerMethod handlerMethod) {
        return new MessagingMessageListenerAdapter(handlerMethod);
    }

    protected <T> AsyncMessageListener<T> createAsyncMessageListenerInstance(InvocableHandlerMethod handlerMethod) {
        return new AsyncMessagingMessageListenerAdapter(handlerMethod);
    }
}

