/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.annotation;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.sqs.annotation.AbstractListenerAnnotationBeanPostProcessor;
import io.awspring.cloud.sqs.annotation.SqsListener;
import io.awspring.cloud.sqs.config.Endpoint;
import io.awspring.cloud.sqs.config.SqsEndpoint;
import io.awspring.cloud.sqs.support.resolver.BatchVisibilityHandlerMethodArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.NotificationMessageArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.QueueAttributesMethodArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.SqsMessageMethodArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.VisibilityHandlerMethodArgumentResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;

public class SqsListenerAnnotationBeanPostProcessor
extends AbstractListenerAnnotationBeanPostProcessor<SqsListener> {
    private static final String GENERATED_ID_PREFIX = "io.awspring.cloud.sqs.sqsListenerEndpointContainer#";

    @Override
    protected Class<SqsListener> getAnnotationClass() {
        return SqsListener.class;
    }

    @Override
    protected Endpoint createEndpoint(SqsListener sqsListenerAnnotation) {
        return SqsEndpoint.builder().queueNames(this.resolveEndpointNames(sqsListenerAnnotation.value())).factoryBeanName(this.resolveAsString(sqsListenerAnnotation.factory(), "factory")).id(this.getEndpointId(sqsListenerAnnotation.id())).pollTimeoutSeconds(this.resolveAsInteger(sqsListenerAnnotation.pollTimeoutSeconds(), "pollTimeoutSeconds")).maxMessagesPerPoll(this.resolveAsInteger(sqsListenerAnnotation.maxMessagesPerPoll(), "maxMessagesPerPoll")).maxConcurrentMessages(this.resolveAsInteger(sqsListenerAnnotation.maxConcurrentMessages(), "maxConcurrentMessages")).messageVisibility(this.resolveAsInteger(sqsListenerAnnotation.messageVisibilitySeconds(), "messageVisibility")).acknowledgementMode(this.resolveAcknowledgement(sqsListenerAnnotation.acknowledgementMode())).build();
    }

    @Override
    protected String getGeneratedIdPrefix() {
        return GENERATED_ID_PREFIX;
    }

    @Override
    protected String getMessageListenerContainerRegistryBeanName() {
        return "io.awspring.cloud.messaging.internalEndpointRegistryBeanName";
    }

    @Override
    protected Collection<HandlerMethodArgumentResolver> createAdditionalArgumentResolvers() {
        return Arrays.asList(new VisibilityHandlerMethodArgumentResolver("Sqs_VisibilityTimeout"), new BatchVisibilityHandlerMethodArgumentResolver("Sqs_VisibilityTimeout"), new SqsMessageMethodArgumentResolver(), new QueueAttributesMethodArgumentResolver());
    }

    @Override
    protected Collection<HandlerMethodArgumentResolver> createAdditionalArgumentResolvers(MessageConverter messageConverter, ObjectMapper objectMapper) {
        ArrayList<HandlerMethodArgumentResolver> argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>(this.createAdditionalArgumentResolvers());
        if (objectMapper != null) {
            argumentResolvers.add(new NotificationMessageArgumentResolver(messageConverter, objectMapper));
        }
        return argumentResolvers;
    }
}

