/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import io.awspring.cloud.sqs.CollectionUtils;
import io.awspring.cloud.sqs.listener.BatchVisibility;
import io.awspring.cloud.sqs.listener.QueueMessageVisibility;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;

public class QueueMessageBatchVisibility
implements BatchVisibility {
    private static final Logger logger = LoggerFactory.getLogger(QueueMessageVisibility.class);
    private final SqsAsyncClient sqsAsyncClient;
    private final String queueUrl;
    private final Collection<String> receiptHandles;

    public QueueMessageBatchVisibility(SqsAsyncClient sqsAsyncClient, String queueUrl, Collection<String> receiptHandles) {
        this.sqsAsyncClient = sqsAsyncClient;
        this.queueUrl = queueUrl;
        this.receiptHandles = receiptHandles;
    }

    @Override
    public CompletableFuture<Void> changeToAsync(int seconds) {
        return this.changeToAsyncBatch(seconds);
    }

    private CompletableFuture<Void> changeToAsyncBatch(int seconds) {
        return CompletableFuture.allOf((CompletableFuture[])CollectionUtils.partition(this.receiptHandles, 10).stream().map(batch -> this.doChangeVisibility(seconds, (Collection<String>)batch).thenRun(() -> logger.trace("Changed the visibility of {} message to {} seconds", (Object)batch.size(), (Object)seconds))).toArray(CompletableFuture[]::new));
    }

    private CompletableFuture<ChangeMessageVisibilityBatchResponse> doChangeVisibility(int seconds, Collection<String> batch) {
        return this.sqsAsyncClient.changeMessageVisibilityBatch(req -> req.queueUrl(this.queueUrl).entries(this.createEntries(seconds, batch)));
    }

    private List<ChangeMessageVisibilityBatchRequestEntry> createEntries(int seconds, Collection<String> batch) {
        return batch.stream().map(handle -> (ChangeMessageVisibilityBatchRequestEntry)ChangeMessageVisibilityBatchRequestEntry.builder().receiptHandle(handle).id(UUID.randomUUID().toString()).visibilityTimeout(Integer.valueOf(seconds)).build()).toList();
    }
}

