/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class ConfigUtils {
    public static final ConfigUtils INSTANCE = new ConfigUtils();

    private ConfigUtils() {
    }

    public <T> ConfigUtils acceptIfNotNull(@Nullable T value, Consumer<T> consumer) {
        if (value != null) {
            consumer.accept(value);
        }
        return this;
    }

    public <T> ConfigUtils acceptIfNotNullOrElse(Consumer<T> consumer, @Nullable T value, T fallback) {
        if (value != null) {
            consumer.accept(value);
        } else {
            consumer.accept(fallback);
        }
        return this;
    }

    public <T, V> ConfigUtils acceptBothIfNoneNull(@Nullable T firstValue, @Nullable V secondValue, BiConsumer<T, V> consumer) {
        if (firstValue != null && secondValue != null) {
            consumer.accept(firstValue, secondValue);
        }
        return this;
    }

    @SafeVarargs
    public final <T> ConfigUtils acceptFirstNonNull(Consumer<T> consumer, T ... values) {
        Arrays.stream(values).filter(Objects::nonNull).findFirst().ifPresent(consumer);
        return this;
    }

    public <T> ConfigUtils acceptIfNotEmpty(Collection<T> value, Consumer<Collection<T>> consumer) {
        if (!CollectionUtils.isEmpty(value)) {
            consumer.accept(value);
        }
        return this;
    }

    public <T> ConfigUtils acceptIfInstance(@Nullable Object value, Class<T> clazz, Consumer<T> consumer) {
        if (value != null && clazz.isAssignableFrom(value.getClass())) {
            consumer.accept(clazz.cast(value));
        }
        return this;
    }

    public <T> ConfigUtils acceptManyIfInstance(Collection<?> values, Class<T> clazz, Consumer<T> consumer) {
        values.forEach(value -> this.acceptIfInstance(value, clazz, consumer));
        return this;
    }

    public <T> ConfigUtils acceptMany(Collection<T> values, Consumer<T> consumer) {
        values.forEach(consumer);
        return this;
    }
}

