/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import io.awspring.cloud.sqs.listener.AbstractContainerOptions;
import io.awspring.cloud.sqs.listener.FifoBatchGroupingStrategy;
import io.awspring.cloud.sqs.listener.QueueNotFoundStrategy;
import io.awspring.cloud.sqs.listener.SqsContainerOptionsBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;

public class SqsContainerOptions
extends AbstractContainerOptions<SqsContainerOptions, SqsContainerOptionsBuilder> {
    @Nullable
    private final Duration messageVisibility;
    private final FifoBatchGroupingStrategy fifoBatchGroupingStrategy;
    private final Collection<QueueAttributeName> queueAttributeNames;
    private final Collection<String> messageAttributeNames;
    private final Collection<String> messageSystemAttributeNames;
    private final QueueNotFoundStrategy queueNotFoundStrategy;

    protected SqsContainerOptions(BuilderImpl builder) {
        super(builder);
        this.queueAttributeNames = builder.queueAttributeNames;
        this.messageAttributeNames = builder.messageAttributeNames;
        this.messageSystemAttributeNames = builder.messageSystemAttributeNames;
        this.messageVisibility = builder.messageVisibility;
        this.queueNotFoundStrategy = builder.queueNotFoundStrategy;
        this.fifoBatchGroupingStrategy = builder.fifoBatchGroupingStrategy;
    }

    public static SqsContainerOptionsBuilder builder() {
        return new BuilderImpl();
    }

    public Collection<QueueAttributeName> getQueueAttributeNames() {
        return this.queueAttributeNames;
    }

    public Collection<String> getMessageAttributeNames() {
        return this.messageAttributeNames;
    }

    public Collection<String> getMessageSystemAttributeNames() {
        return this.messageSystemAttributeNames;
    }

    @Nullable
    public Duration getMessageVisibility() {
        return this.messageVisibility;
    }

    public FifoBatchGroupingStrategy getFifoBatchGroupingStrategy() {
        return this.fifoBatchGroupingStrategy;
    }

    public QueueNotFoundStrategy getQueueNotFoundStrategy() {
        return this.queueNotFoundStrategy;
    }

    @Override
    public SqsContainerOptionsBuilder toBuilder() {
        return new BuilderImpl(this);
    }

    private static class BuilderImpl
    extends AbstractContainerOptions.Builder<SqsContainerOptionsBuilder, SqsContainerOptions>
    implements SqsContainerOptionsBuilder {
        private static final List<QueueAttributeName> DEFAULT_QUEUE_ATTRIBUTES_NAMES = Collections.emptyList();
        private static final List<String> DEFAULT_MESSAGE_ATTRIBUTES_NAMES = Collections.singletonList(QueueAttributeName.ALL.toString());
        private static final List<String> DEFAULT_MESSAGE_SYSTEM_ATTRIBUTES = Collections.singletonList(QueueAttributeName.ALL.toString());
        private static final QueueNotFoundStrategy DEFAULT_QUEUE_NOT_FOUND_STRATEGY = QueueNotFoundStrategy.CREATE;
        private Collection<QueueAttributeName> queueAttributeNames = DEFAULT_QUEUE_ATTRIBUTES_NAMES;
        private Collection<String> messageAttributeNames = DEFAULT_MESSAGE_ATTRIBUTES_NAMES;
        private Collection<String> messageSystemAttributeNames = DEFAULT_MESSAGE_SYSTEM_ATTRIBUTES;
        private QueueNotFoundStrategy queueNotFoundStrategy = DEFAULT_QUEUE_NOT_FOUND_STRATEGY;
        private FifoBatchGroupingStrategy fifoBatchGroupingStrategy = FifoBatchGroupingStrategy.PROCESS_MESSAGE_GROUPS_IN_PARALLEL_BATCHES;
        @Nullable
        private Duration messageVisibility;

        protected BuilderImpl() {
        }

        protected BuilderImpl(SqsContainerOptions options) {
            super(options);
            this.queueAttributeNames = options.queueAttributeNames;
            this.messageAttributeNames = options.messageAttributeNames;
            this.messageSystemAttributeNames = options.messageSystemAttributeNames;
            this.messageVisibility = options.messageVisibility;
            this.fifoBatchGroupingStrategy = options.fifoBatchGroupingStrategy;
            this.queueNotFoundStrategy = options.queueNotFoundStrategy;
        }

        @Override
        public SqsContainerOptionsBuilder queueAttributeNames(Collection<QueueAttributeName> queueAttributeNames) {
            Assert.notEmpty(queueAttributeNames, (String)"queueAttributeNames cannot be empty");
            this.queueAttributeNames = Collections.unmodifiableCollection(new ArrayList<QueueAttributeName>(queueAttributeNames));
            return this;
        }

        @Override
        public SqsContainerOptionsBuilder messageAttributeNames(Collection<String> messageAttributeNames) {
            Assert.notEmpty(messageAttributeNames, (String)"messageAttributeNames cannot be empty");
            this.messageAttributeNames = Collections.unmodifiableCollection(new ArrayList<String>(messageAttributeNames));
            return this;
        }

        @Override
        public SqsContainerOptionsBuilder messageSystemAttributeNames(Collection<MessageSystemAttributeName> messageSystemAttributeNames) {
            Assert.notEmpty(messageSystemAttributeNames, (String)"messageSystemAttributeNames cannot be empty");
            this.messageSystemAttributeNames = messageSystemAttributeNames.stream().map(MessageSystemAttributeName::toString).collect(Collectors.toList());
            return this;
        }

        @Override
        public SqsContainerOptionsBuilder messageVisibility(Duration messageVisibility) {
            Assert.notNull((Object)messageVisibility, (String)"messageVisibility cannot be null");
            this.messageVisibility = messageVisibility;
            return this;
        }

        @Override
        public SqsContainerOptionsBuilder fifoBatchGroupingStrategy(FifoBatchGroupingStrategy fifoBatchGroupingStrategy) {
            Assert.notNull((Object)((Object)fifoBatchGroupingStrategy), (String)"fifoBatchGroupingStrategy cannot be null");
            this.fifoBatchGroupingStrategy = fifoBatchGroupingStrategy;
            return this;
        }

        @Override
        public SqsContainerOptionsBuilder queueNotFoundStrategy(QueueNotFoundStrategy queueNotFoundStrategy) {
            Assert.notNull((Object)((Object)queueNotFoundStrategy), (String)"queueNotFoundStrategy cannot be null");
            this.queueNotFoundStrategy = queueNotFoundStrategy;
            return this;
        }

        @Override
        public SqsContainerOptions build() {
            return new SqsContainerOptions(this);
        }

        @Override
        public SqsContainerOptionsBuilder createCopy() {
            BuilderImpl builder = new BuilderImpl();
            ReflectionUtils.shallowCopyFieldState((Object)this, (Object)builder);
            return builder;
        }

        @Override
        public void fromBuilder(SqsContainerOptionsBuilder builder) {
            ReflectionUtils.shallowCopyFieldState((Object)builder, (Object)this);
        }
    }
}

