/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;

public class SnsMessageConverter
implements SmartMessageConverter {
    private final ObjectMapper jsonMapper;
    private final MessageConverter payloadConverter;

    public SnsMessageConverter(MessageConverter payloadConverter, ObjectMapper jsonMapper) {
        Assert.notNull((Object)payloadConverter, (String)"payloadConverter must not be null");
        Assert.notNull((Object)jsonMapper, (String)"jsonMapper must not be null");
        this.payloadConverter = payloadConverter;
        this.jsonMapper = jsonMapper;
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        JsonNode jsonNode;
        Assert.notNull(message, (String)"message must not be null");
        Assert.notNull(targetClass, (String)"target class must not be null");
        try {
            jsonNode = this.jsonMapper.readTree(message.getPayload().toString());
        }
        catch (Exception e) {
            throw new MessageConversionException("Could not read JSON", (Throwable)e);
        }
        if (!jsonNode.has("Type")) {
            throw new MessageConversionException("Payload: '" + message.getPayload() + "' does not contain a Type attribute", null);
        }
        if (!"Notification".equals(jsonNode.get("Type").asText())) {
            throw new MessageConversionException("Payload: '" + message.getPayload() + "' is not a valid notification", null);
        }
        if (!jsonNode.has("Message")) {
            throw new MessageConversionException("Payload: '" + message.getPayload() + "' does not contain a message", null);
        }
        String messagePayload = jsonNode.get("Message").asText();
        GenericMessage genericMessage = new GenericMessage((Object)messagePayload);
        Object convertedMessage = this.payloadConverter instanceof SmartMessageConverter ? ((SmartMessageConverter)this.payloadConverter).fromMessage((Message)genericMessage, targetClass, conversionHint) : this.payloadConverter.fromMessage((Message)genericMessage, targetClass);
        return new SnsMessageWrapper(jsonNode.path("Subject").asText(), convertedMessage);
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        return this.fromMessage(message, targetClass, null);
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        throw new UnsupportedOperationException("This converter only supports reading a SNS notification and not writing them");
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers, Object conversionHint) {
        throw new UnsupportedOperationException("This converter only supports reading a SNS notification and not writing them");
    }

    public record SnsMessageWrapper(String subject, Object message) {
    }
}

