/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.pipeline;

import io.awspring.cloud.sqs.CompletableFutures;
import io.awspring.cloud.sqs.listener.ListenerExecutionFailedException;
import io.awspring.cloud.sqs.listener.MessageProcessingContext;
import io.awspring.cloud.sqs.listener.interceptor.AsyncMessageInterceptor;
import io.awspring.cloud.sqs.listener.pipeline.MessageProcessingPipeline;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;

public abstract class AbstractAfterProcessingInterceptorExecutionStage<T>
implements MessageProcessingPipeline<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAfterProcessingInterceptorExecutionStage.class);

    @Override
    public CompletableFuture<Message<T>> process(CompletableFuture<Message<T>> messageFuture, MessageProcessingContext<T> context) {
        return CompletableFutures.handleCompose(messageFuture, (v, t) -> t == null ? this.applyInterceptors((Message<T>)v, null, this.getMessageInterceptors(context)) : this.applyInterceptors(ListenerExecutionFailedException.unwrapMessage(t), (Throwable)t, this.getMessageInterceptors(context)).thenCompose(msg -> CompletableFutures.failedFuture(t)));
    }

    protected abstract Collection<AsyncMessageInterceptor<T>> getMessageInterceptors(MessageProcessingContext<T> var1);

    private CompletableFuture<Message<T>> applyInterceptors(Message<T> message, Throwable t, Collection<AsyncMessageInterceptor<T>> messageInterceptors) {
        return messageInterceptors.stream().reduce(CompletableFuture.completedFuture(null), (voidFuture, interceptor) -> voidFuture.thenCompose(theVoid -> interceptor.afterProcessing(message, t)), (a, b) -> a).thenApply(theVoid -> message);
    }

    @Override
    public CompletableFuture<Collection<Message<T>>> processMany(CompletableFuture<Collection<Message<T>>> messagesFuture, MessageProcessingContext<T> context) {
        return CompletableFutures.handleCompose(messagesFuture, (v, t) -> t == null ? this.applyInterceptors((Collection<Message<T>>)v, null, this.getMessageInterceptors(context)) : this.applyInterceptors(ListenerExecutionFailedException.unwrapMessages(t), (Throwable)t, this.getMessageInterceptors(context)).thenCompose(msg -> CompletableFutures.failedFuture(t)));
    }

    private CompletableFuture<Collection<Message<T>>> applyInterceptors(Collection<Message<T>> messages, Throwable t, Collection<AsyncMessageInterceptor<T>> messageInterceptors) {
        return messageInterceptors.stream().reduce(CompletableFuture.completedFuture(null), (voidFuture, interceptor) -> voidFuture.thenCompose(theVoid -> interceptor.afterProcessing(messages, t)), (a, b) -> a).thenApply(theVoid -> messages);
    }
}

