/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.operations;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.springframework.core.NestedRuntimeException;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class MessagingOperationFailedException
extends NestedRuntimeException {
    private final String endpoint;
    private final Collection<Message<?>> failedMessages;

    public MessagingOperationFailedException(String msg, String endpoint) {
        this(msg, endpoint, null);
    }

    public MessagingOperationFailedException(String msg, String endpoint, @Nullable Throwable cause) {
        this(msg, endpoint, Collections.emptyList(), cause);
    }

    public MessagingOperationFailedException(String msg, String endpoint, Message<?> message, @Nullable Throwable cause) {
        this(msg, endpoint, Collections.singletonList(message), cause);
    }

    public <T> MessagingOperationFailedException(String msg, String endpoint, Collection<Message<T>> messages, @Nullable Throwable cause) {
        super(msg, cause);
        this.endpoint = endpoint;
        this.failedMessages = Collections.unmodifiableCollection(messages);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Collection<Message<?>> getFailedMessages() {
        return this.failedMessages;
    }

    public Optional<Message<?>> getFailedMessage() {
        Assert.isTrue((this.failedMessages.size() < 2 ? 1 : 0) != 0, (String)"More than one message found");
        return this.failedMessages.stream().findFirst();
    }
}

