/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.core;

import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SnsNotification<T> {
    private final T payload;
    @Nullable
    private final Map<String, Object> headers;

    public static <T> SnsNotification<T> of(T payload) {
        return new SnsNotification<T>(payload, null);
    }

    public static <T> Builder<T> builder(T payload) {
        return new Builder<T>(payload);
    }

    public SnsNotification(T payload, @Nullable Map<String, Object> headers) {
        Assert.notNull(payload, (String)"payload is required");
        this.payload = payload;
        this.headers = headers;
    }

    @Nullable
    public String getSubject() {
        Map<String, Object> headersMap = this.headers;
        if (headersMap != null) {
            return (String)headersMap.get("notification-subject");
        }
        return null;
    }

    public T getPayload() {
        return this.payload;
    }

    @Nullable
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Nullable
    public String getGroupId() {
        Map<String, Object> headersMap = this.headers;
        if (headersMap != null) {
            return (String)headersMap.get("message-group-id");
        }
        return null;
    }

    @Nullable
    public String getDeduplicationId() {
        Map<String, Object> headersMap = this.headers;
        if (headersMap != null) {
            return (String)headersMap.get("message-deduplication-id");
        }
        return null;
    }

    public static class Builder<T> {
        private final T payload;
        private final Map<String, Object> headers = new HashMap<String, Object>();

        Builder(T payload) {
            this.payload = payload;
        }

        public Builder<T> subject(String subject) {
            this.headers.put("notification-subject", subject);
            return this;
        }

        public Builder<T> headers(Map<String, Object> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder<T> header(String key, Object value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder<T> groupId(String groupId) {
            this.headers.put("message-group-id", groupId);
            return this;
        }

        public Builder<T> deduplicationId(String deduplicationId) {
            this.headers.put("message-deduplication-id", deduplicationId);
            return this;
        }

        public SnsNotification<T> build() {
            return new SnsNotification<T>(this.payload, this.headers);
        }
    }
}

