/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.core;

import io.awspring.cloud.sns.core.TopicArnResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;
import software.amazon.awssdk.arns.Arn;

public class CachingTopicArnResolver
implements TopicArnResolver {
    private final TopicArnResolver delegate;
    private final Map<String, Arn> cache = new ConcurrentHashMap<String, Arn>();

    public CachingTopicArnResolver(TopicArnResolver topicArnResolver) {
        Assert.notNull((Object)topicArnResolver, (String)"topicArnResolver is required");
        this.delegate = topicArnResolver;
    }

    @Override
    public Arn resolveTopicArn(String topicName) {
        Assert.notNull((Object)topicName, (String)"topicName is required");
        if (topicName.toLowerCase().startsWith("arn:")) {
            return this.delegate.resolveTopicArn(topicName);
        }
        return this.cache.computeIfAbsent(topicName, this.delegate::resolveTopicArn);
    }

    int cacheSize() {
        return this.cache.size();
    }
}

