/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.core;

import io.awspring.cloud.sns.core.TopicArnResolver;
import java.util.Map;
import org.springframework.util.Assert;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;

public class DefaultTopicArnResolver
implements TopicArnResolver {
    private final SnsClient snsClient;

    public DefaultTopicArnResolver(SnsClient snsClient) {
        Assert.notNull((Object)snsClient, (String)"snsClient is required");
        this.snsClient = snsClient;
    }

    @Override
    public Arn resolveTopicArn(String topicName) {
        Assert.notNull((Object)topicName, (String)"topicName must not be null");
        if (topicName.toLowerCase().startsWith("arn:")) {
            return Arn.fromString((String)topicName);
        }
        CreateTopicRequest.Builder builder = CreateTopicRequest.builder().name(topicName);
        if (topicName.endsWith(".fifo")) {
            builder.attributes(Map.of("FifoTopic", "true"));
        }
        return Arn.fromString((String)this.snsClient.createTopic((CreateTopicRequest)builder.build()).topicArn());
    }
}

