/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.sms;

import io.awspring.cloud.sns.sms.SmsType;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;

public class SmsMessageAttributes {
    @Nullable
    private String senderID;
    @Nullable
    private String originationNumber;
    @Nullable
    private String maxPrice;
    @Nullable
    private SmsType smsType;
    @Nullable
    private String entityId;
    @Nullable
    private String templateId;

    Map<String, MessageAttributeValue> convertAndPopulate() {
        HashMap<String, MessageAttributeValue> map = new HashMap<String, MessageAttributeValue>();
        SmsMessageAttributes.populateMapWithStringValue("AWS.SNS.SMS.SenderID", this.getSenderID(), map);
        SmsMessageAttributes.populateMapWithStringValue("AWS.MM.SMS.OriginationNumber", this.getOriginationNumber(), map);
        SmsMessageAttributes.populateMapWithNumberValue("AWS.SNS.SMS.MaxPrice", this.getMaxPrice(), map);
        SmsMessageAttributes.populateMapWithStringValue("AWS.SNS.SMS.SMSType", this.getSmsType() != null ? this.getSmsType().getType() : null, map);
        SmsMessageAttributes.populateMapWithStringValue("AWS.MM.SMS.EntityId", this.getEntityId(), map);
        SmsMessageAttributes.populateMapWithStringValue("AWS.MM.SMS.TemplateId", this.getTemplateId(), map);
        return map;
    }

    @Nullable
    public String getSenderID() {
        return this.senderID;
    }

    public void setSenderID(@Nullable String senderID) {
        this.senderID = senderID;
    }

    @Nullable
    public String getOriginationNumber() {
        return this.originationNumber;
    }

    public void setOriginationNumber(@Nullable String originationNumber) {
        this.originationNumber = originationNumber;
    }

    @Nullable
    public String getMaxPrice() {
        return this.maxPrice;
    }

    public void setMaxPrice(@Nullable String maxPrice) {
        this.maxPrice = maxPrice;
    }

    @Nullable
    public SmsType getSmsType() {
        return this.smsType;
    }

    public void setSmsType(@Nullable SmsType smsType) {
        this.smsType = smsType;
    }

    @Nullable
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(@Nullable String entityId) {
        this.entityId = entityId;
    }

    @Nullable
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(@Nullable String templateId) {
        this.templateId = templateId;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void populateMapWithStringValue(String attributeCode, @Nullable String value, Map<String, MessageAttributeValue> messageAttributeValueMap) {
        if (value != null) {
            messageAttributeValueMap.put(attributeCode, (MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue(value).build());
        }
    }

    private static void populateMapWithNumberValue(String attributeCode, @Nullable String value, Map<String, MessageAttributeValue> messageAttributeValueMap) {
        if (value != null) {
            messageAttributeValueMap.put(attributeCode, (MessageAttributeValue)MessageAttributeValue.builder().dataType("Number").stringValue(value).build());
        }
    }

    public static final class Builder {
        @Nullable
        private String senderID;
        @Nullable
        private String originationNumber;
        @Nullable
        private String maxPrice;
        @Nullable
        private SmsType smsType;
        @Nullable
        private String entityId;
        @Nullable
        private String templateId;

        private Builder() {
        }

        public Builder senderID(@Nullable String senderID) {
            this.senderID = senderID;
            return this;
        }

        public Builder originationNumber(@Nullable String originationNumber) {
            this.originationNumber = originationNumber;
            return this;
        }

        public Builder maxPrice(@Nullable String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public Builder smsType(@Nullable SmsType smsType) {
            this.smsType = smsType;
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public SmsMessageAttributes build() {
            SmsMessageAttributes smsMessageAttributes = new SmsMessageAttributes();
            smsMessageAttributes.setSenderID(this.senderID);
            smsMessageAttributes.setOriginationNumber(this.originationNumber);
            smsMessageAttributes.setMaxPrice(this.maxPrice);
            smsMessageAttributes.setSmsType(this.smsType);
            smsMessageAttributes.setEntityId(this.entityId);
            smsMessageAttributes.setTemplateId(this.templateId);
            return smsMessageAttributes;
        }
    }
}

