/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.core;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.NumberUtils;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.PublishRequest;

public class TopicMessageChannel
extends AbstractMessageChannel {
    private static final JsonStringEncoder jsonStringEncoder = JsonStringEncoder.getInstance();
    private final SnsClient snsClient;
    private final Arn topicArn;

    public TopicMessageChannel(SnsClient snsClient, Arn topicArn) {
        this.snsClient = snsClient;
        this.topicArn = topicArn;
    }

    @Nullable
    private static String findNotificationSubject(Message<?> message) {
        Object notificationSubjectHeader = message.getHeaders().get((Object)"notification-subject");
        return notificationSubjectHeader != null ? notificationSubjectHeader.toString() : null;
    }

    protected boolean sendInternal(Message<?> message, long timeout) {
        PublishRequest.Builder publishRequestBuilder = PublishRequest.builder();
        publishRequestBuilder.topicArn(this.topicArn.toString()).message(message.getPayload().toString()).subject(TopicMessageChannel.findNotificationSubject(message));
        Map<String, MessageAttributeValue> messageAttributes = this.toSnsMessageAttributes(message);
        if (!messageAttributes.isEmpty()) {
            publishRequestBuilder.messageAttributes(messageAttributes);
        }
        Optional.ofNullable(message.getHeaders().get((Object)"message-group-id", String.class)).ifPresent(arg_0 -> ((PublishRequest.Builder)publishRequestBuilder).messageGroupId(arg_0));
        Optional.ofNullable(message.getHeaders().get((Object)"message-deduplication-id", String.class)).ifPresent(arg_0 -> ((PublishRequest.Builder)publishRequestBuilder).messageDeduplicationId(arg_0));
        this.snsClient.publish((PublishRequest)publishRequestBuilder.build());
        return true;
    }

    private Map<String, MessageAttributeValue> toSnsMessageAttributes(Message<?> message) {
        HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>();
        for (Map.Entry messageHeader : message.getHeaders().entrySet()) {
            String messageHeaderName = (String)messageHeader.getKey();
            Object messageHeaderValue = messageHeader.getValue();
            if (this.isSkipHeader(messageHeaderName)) continue;
            if ("contentType".equals(messageHeaderName) && messageHeaderValue != null) {
                messageAttributes.put(messageHeaderName, this.getContentTypeMessageAttribute(messageHeaderValue));
                continue;
            }
            if ("id".equals(messageHeaderName) && messageHeaderValue != null) {
                messageAttributes.put(messageHeaderName, this.getStringMessageAttribute(messageHeaderValue.toString()));
                continue;
            }
            if (messageHeaderValue instanceof String) {
                messageAttributes.put(messageHeaderName, this.getStringMessageAttribute((String)messageHeaderValue));
                continue;
            }
            if (messageHeaderValue instanceof Number) {
                messageAttributes.put(messageHeaderName, this.getNumberMessageAttribute(messageHeaderValue));
                continue;
            }
            if (messageHeaderValue instanceof ByteBuffer) {
                messageAttributes.put(messageHeaderName, this.getBinaryMessageAttribute((ByteBuffer)messageHeaderValue));
                continue;
            }
            if (messageHeaderValue instanceof List) {
                messageAttributes.put(messageHeaderName, this.getStringArrayMessageAttribute((List)messageHeaderValue));
                continue;
            }
            this.logger.warn((Object)String.format("Message header with name '%s' and type '%s' cannot be sent as message attribute because it is not supported by SNS.", messageHeaderName, messageHeaderValue != null ? messageHeaderValue.getClass().getName() : ""));
        }
        return messageAttributes;
    }

    private boolean isSkipHeader(String headerName) {
        return "notification-subject".equals(headerName) || "message-group-id".equals(headerName) || "message-deduplication-id".equals(headerName);
    }

    private MessageAttributeValue getStringArrayMessageAttribute(List<Object> messageHeaderValue) {
        String stringValue = "[" + messageHeaderValue.stream().map(item -> "\"" + String.valueOf(jsonStringEncoder.quoteAsString(item.toString())) + "\"").collect(Collectors.joining(", ")) + "]";
        return (MessageAttributeValue)MessageAttributeValue.builder().dataType("String.Array").stringValue(stringValue).build();
    }

    private MessageAttributeValue getBinaryMessageAttribute(ByteBuffer messageHeaderValue) {
        return (MessageAttributeValue)MessageAttributeValue.builder().dataType("Binary").binaryValue(SdkBytes.fromByteBuffer((ByteBuffer)messageHeaderValue)).build();
    }

    @Nullable
    private MessageAttributeValue getContentTypeMessageAttribute(Object messageHeaderValue) {
        if (messageHeaderValue instanceof MimeType) {
            return (MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue(messageHeaderValue.toString()).build();
        }
        if (messageHeaderValue instanceof String) {
            return (MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue((String)messageHeaderValue).build();
        }
        return null;
    }

    private MessageAttributeValue getStringMessageAttribute(String messageHeaderValue) {
        return (MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue(messageHeaderValue).build();
    }

    private MessageAttributeValue getNumberMessageAttribute(Object messageHeaderValue) {
        Assert.isTrue((boolean)NumberUtils.STANDARD_NUMBER_TYPES.contains(messageHeaderValue.getClass()), (String)"Only standard number types are accepted as message header.");
        return (MessageAttributeValue)MessageAttributeValue.builder().dataType("Number." + messageHeaderValue.getClass().getName()).stringValue(messageHeaderValue.toString()).build();
    }
}

