/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.Location;
import io.awspring.cloud.s3.ObjectMetadata;
import io.awspring.cloud.s3.S3OutputStreamProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.time.Instant;
import java.util.Map;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.WritableResource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetUrlRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

public class S3Resource
extends AbstractResource
implements WritableResource {
    protected final Location location;
    protected final S3Client s3Client;
    protected final S3OutputStreamProvider s3OutputStreamProvider;
    @Nullable
    private HeadMetadata headMetadata;
    @Nullable
    private ObjectMetadata objectMetadata;

    @Nullable
    public static S3Resource create(String location, S3Client s3Client, S3OutputStreamProvider s3OutputStreamProvider) {
        if (Location.isSimpleStorageResource(location)) {
            return new S3Resource(location, s3Client, s3OutputStreamProvider);
        }
        return null;
    }

    public S3Resource(String location, S3Client s3Client, S3OutputStreamProvider s3OutputStreamProvider) {
        this(Location.of(location), s3Client, s3OutputStreamProvider);
    }

    public S3Resource(String bucket, String key, S3Client s3Client, S3OutputStreamProvider s3OutputStreamProvider) {
        this(Location.of(bucket, key), s3Client, s3OutputStreamProvider);
    }

    public S3Resource(Location location, S3Client s3Client, S3OutputStreamProvider s3OutputStreamProvider) {
        Assert.notNull((Object)location, (String)"location is required");
        Assert.notNull((Object)s3Client, (String)"s3Client is required");
        Assert.notNull((Object)s3OutputStreamProvider, (String)"s3OutputStreamProvider is required");
        this.location = location;
        this.s3Client = s3Client;
        this.s3OutputStreamProvider = s3OutputStreamProvider;
    }

    public URL getURL() throws IOException {
        if (!StringUtils.hasText((String)this.location.getObject())) {
            return new URL("https", this.location.getBucket() + ".s3.amazonaws.com", "/");
        }
        GetUrlRequest getUrlRequest = (GetUrlRequest)GetUrlRequest.builder().bucket(this.getLocation().getBucket()).key(this.location.getObject()).versionId(this.location.getVersion()).build();
        return this.s3Client.utilities().getUrl(getUrlRequest);
    }

    public String getDescription() {
        return this.location.toString();
    }

    public S3Resource createRelative(String relativePath) {
        return new S3Resource(this.location.relative(relativePath), this.s3Client, this.s3OutputStreamProvider);
    }

    public InputStream getInputStream() throws IOException {
        return this.s3Client.getObject(request -> request.bucket(this.location.getBucket()).key(this.location.getObject()).versionId(this.location.getVersion()));
    }

    public String contentType() {
        if (this.headMetadata == null) {
            this.fetchMetadata();
        }
        return this.headMetadata.contentType;
    }

    public void setObjectMetadata(@Nullable ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public boolean exists() {
        try {
            this.fetchMetadata();
            return true;
        }
        catch (NoSuchKeyException e) {
            return false;
        }
    }

    public long contentLength() {
        if (this.headMetadata == null) {
            this.fetchMetadata();
        }
        return this.headMetadata.contentLength;
    }

    public long lastModified() {
        if (this.headMetadata == null) {
            this.fetchMetadata();
        }
        return this.headMetadata.lastModified.toEpochMilli();
    }

    public File getFile() {
        throw new UnsupportedOperationException("Amazon S3 resource can not be resolved to java.io.File objects.Use getInputStream() to retrieve the contents of the object!");
    }

    public Map<String, String> metadata() {
        if (this.headMetadata == null) {
            this.fetchMetadata();
        }
        return this.headMetadata.metadata;
    }

    private void fetchMetadata() {
        HeadObjectResponse response = this.s3Client.headObject(request -> request.bucket(this.location.getBucket()).key(this.location.getObject()).versionId(this.location.getVersion()));
        this.headMetadata = new HeadMetadata(response);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.s3OutputStreamProvider.create(this.location.getBucket(), this.location.getObject(), this.objectMetadata);
    }

    public String getFilename() {
        return this.location.getObject();
    }

    public Location getLocation() {
        return this.location;
    }

    private static class HeadMetadata {
        private final Long contentLength;
        private final Instant lastModified;
        private final String contentType;
        private final Map<String, String> metadata;

        HeadMetadata(HeadObjectResponse headObjectResponse) {
            this.contentLength = headObjectResponse.contentLength();
            this.lastModified = headObjectResponse.lastModified();
            this.contentType = headObjectResponse.contentType();
            this.metadata = headObjectResponse.metadata();
        }
    }
}

