/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.parameterstore;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.lang.Nullable;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.services.ssm.model.Parameter;

public class ParameterStorePropertySource
extends EnumerablePropertySource<SsmClient> {
    private static Log LOG = LogFactory.getLog(ParameterStorePropertySource.class);
    private final String context;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public ParameterStorePropertySource(String context, SsmClient ssmClient) {
        super(context, (Object)ssmClient);
        this.context = context;
    }

    public void init() {
        GetParametersByPathRequest paramsRequest = (GetParametersByPathRequest)GetParametersByPathRequest.builder().path(this.context).recursive(Boolean.valueOf(true)).withDecryption(Boolean.valueOf(true)).build();
        this.getParameters(paramsRequest);
    }

    public String[] getPropertyNames() {
        Set<String> strings = this.properties.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    @Nullable
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void getParameters(GetParametersByPathRequest paramsRequest) {
        GetParametersByPathResponse paramsResult = ((SsmClient)this.source).getParametersByPath(paramsRequest);
        for (Parameter parameter : paramsResult.parameters()) {
            String key = parameter.name().replace(this.context, "").replace('/', '.');
            LOG.debug((Object)("Populating property retrieved from AWS Parameter Store: " + key));
            this.properties.put(key, parameter.value());
        }
        if (paramsResult.nextToken() != null) {
            this.getParameters((GetParametersByPathRequest)paramsRequest.toBuilder().nextToken(paramsResult.nextToken()).build());
        }
    }
}

