/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.paramstore;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import io.awspring.cloud.paramstore.AwsParamStoreProperties;
import io.awspring.cloud.paramstore.AwsParamStorePropertySource;
import io.awspring.cloud.paramstore.AwsParamStorePropertySources;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class AwsParamStorePropertySourceLocator
implements PropertySourceLocator {
    private AWSSimpleSystemsManagement ssmClient;
    private AwsParamStoreProperties properties;
    private final Set<String> contexts = new LinkedHashSet<String>();
    private Log logger = LogFactory.getLog(this.getClass());

    public AwsParamStorePropertySourceLocator(AWSSimpleSystemsManagement ssmClient, AwsParamStoreProperties properties) {
        this.ssmClient = ssmClient;
        this.properties = properties;
    }

    public List<String> getContexts() {
        return new ArrayList<String>(this.contexts);
    }

    public PropertySource<?> locate(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return null;
        }
        ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
        AwsParamStorePropertySources sources = new AwsParamStorePropertySources(this.properties, this.logger);
        List<String> profiles = Arrays.asList(env.getActiveProfiles());
        this.contexts.addAll(sources.getAutomaticContexts(profiles));
        CompositePropertySource composite = new CompositePropertySource("aws-param-store");
        for (String propertySourceContext : this.contexts) {
            AwsParamStorePropertySource propertySource = sources.createPropertySource(propertySourceContext, !this.properties.isFailFast(), this.ssmClient);
            if (propertySource == null) continue;
            composite.addPropertySource((PropertySource)propertySource);
        }
        return composite;
    }
}

