/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.endpoint.config;

import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.message.SnsMessageManager;
import io.awspring.cloud.messaging.endpoint.NotificationMessageHandlerMethodArgumentResolver;
import io.awspring.cloud.messaging.endpoint.NotificationStatusHandlerMethodArgumentResolver;
import io.awspring.cloud.messaging.endpoint.NotificationSubjectHandlerMethodArgumentResolver;
import java.util.Optional;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;

public final class NotificationHandlerMethodArgumentResolverConfigurationUtils {
    private NotificationHandlerMethodArgumentResolverConfigurationUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static HandlerMethodArgumentResolver getNotificationHandlerMethodArgumentResolver(AmazonSNS amazonSns, Optional<SnsMessageManager> snsMessageManager) {
        HandlerMethodArgumentResolverComposite composite = new HandlerMethodArgumentResolverComposite();
        composite.addResolver((HandlerMethodArgumentResolver)new NotificationStatusHandlerMethodArgumentResolver(amazonSns));
        if (snsMessageManager.isPresent()) {
            composite.addResolver((HandlerMethodArgumentResolver)new NotificationMessageHandlerMethodArgumentResolver(snsMessageManager.get()));
        } else {
            composite.addResolver((HandlerMethodArgumentResolver)new NotificationMessageHandlerMethodArgumentResolver(null));
        }
        composite.addResolver((HandlerMethodArgumentResolver)new NotificationSubjectHandlerMethodArgumentResolver());
        return composite;
    }
}

