/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.support;

import io.awspring.cloud.messaging.config.annotation.NotificationSubject;
import io.awspring.cloud.messaging.support.converter.NotificationRequestConverter;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.ClassUtils;

public class NotificationSubjectArgumentResolver
implements HandlerMethodArgumentResolver {
    private final MessageConverter converter = new NotificationRequestConverter((MessageConverter)new StringMessageConverter());

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(NotificationSubject.class) && ClassUtils.isAssignable(String.class, (Class)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        return ((NotificationRequestConverter.NotificationRequest)this.converter.fromMessage(message, String.class)).getSubject();
    }
}

