/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.config.annotation;

import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.context.config.annotation.ContextDefaultConfigurationRegistrar;
import io.awspring.cloud.core.env.ResourceIdResolver;
import io.awspring.cloud.messaging.config.QueueMessageHandlerFactory;
import io.awspring.cloud.messaging.config.SimpleMessageListenerContainerFactory;
import io.awspring.cloud.messaging.listener.QueueMessageHandler;
import io.awspring.cloud.messaging.listener.SimpleMessageListenerContainer;
import java.util.Arrays;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.util.CollectionUtils;

@Configuration
@Import(value={ContextDefaultConfigurationRegistrar.class})
@Deprecated
public class SqsConfiguration {
    private final SimpleMessageListenerContainerFactory simpleMessageListenerContainerFactory;
    private final QueueMessageHandlerFactory queueMessageHandlerFactory;
    private final BeanFactory beanFactory;
    private final ResourceIdResolver resourceIdResolver;
    private final MappingJackson2MessageConverter mappingJackson2MessageConverter;
    private final ObjectMapper objectMapper;

    public SqsConfiguration(ObjectProvider<SimpleMessageListenerContainerFactory> simpleMessageListenerContainerFactory, ObjectProvider<QueueMessageHandlerFactory> queueMessageHandlerFactory, BeanFactory beanFactory, ObjectProvider<ResourceIdResolver> resourceIdResolver, ObjectProvider<MappingJackson2MessageConverter> mappingJackson2MessageConverter, ObjectProvider<ObjectMapper> objectMapper) {
        this.simpleMessageListenerContainerFactory = (SimpleMessageListenerContainerFactory)simpleMessageListenerContainerFactory.getIfAvailable(SimpleMessageListenerContainerFactory::new);
        this.queueMessageHandlerFactory = (QueueMessageHandlerFactory)queueMessageHandlerFactory.getIfAvailable(QueueMessageHandlerFactory::new);
        this.beanFactory = beanFactory;
        this.resourceIdResolver = (ResourceIdResolver)resourceIdResolver.getIfAvailable();
        this.mappingJackson2MessageConverter = (MappingJackson2MessageConverter)mappingJackson2MessageConverter.getIfAvailable();
        this.objectMapper = (ObjectMapper)objectMapper.getIfAvailable();
    }

    @Bean
    public SimpleMessageListenerContainer simpleMessageListenerContainer(AmazonSQSAsync amazonSqs) {
        if (this.simpleMessageListenerContainerFactory.getAmazonSqs() == null) {
            this.simpleMessageListenerContainerFactory.setAmazonSqs(amazonSqs);
        }
        if (this.simpleMessageListenerContainerFactory.getResourceIdResolver() == null && this.resourceIdResolver != null) {
            this.simpleMessageListenerContainerFactory.setResourceIdResolver(this.resourceIdResolver);
        }
        SimpleMessageListenerContainer simpleMessageListenerContainer = this.simpleMessageListenerContainerFactory.createSimpleMessageListenerContainer();
        simpleMessageListenerContainer.setMessageHandler(this.queueMessageHandler(amazonSqs));
        return simpleMessageListenerContainer;
    }

    @Bean
    public QueueMessageHandler queueMessageHandler(AmazonSQSAsync amazonSqs) {
        if (this.simpleMessageListenerContainerFactory.getQueueMessageHandler() != null) {
            return this.simpleMessageListenerContainerFactory.getQueueMessageHandler();
        }
        return this.getMessageHandler(amazonSqs);
    }

    private QueueMessageHandler getMessageHandler(AmazonSQSAsync amazonSqs) {
        if (this.queueMessageHandlerFactory.getAmazonSqs() == null) {
            this.queueMessageHandlerFactory.setAmazonSqs(amazonSqs);
        }
        if (CollectionUtils.isEmpty(this.queueMessageHandlerFactory.getMessageConverters()) && this.mappingJackson2MessageConverter != null) {
            this.queueMessageHandlerFactory.setMessageConverters(Arrays.asList(this.mappingJackson2MessageConverter));
        }
        this.queueMessageHandlerFactory.setBeanFactory(this.beanFactory);
        this.queueMessageHandlerFactory.setObjectMapper(this.objectMapper);
        return this.queueMessageHandlerFactory.createQueueMessageHandler();
    }
}

