/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.listener.support;

import io.awspring.cloud.messaging.listener.Acknowledgment;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.ClassUtils;

public class AcknowledgmentHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final String acknowledgmentHeaderName;

    public AcknowledgmentHandlerMethodArgumentResolver(String acknowledgmentHeaderName) {
        this.acknowledgmentHeaderName = acknowledgmentHeaderName;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return ClassUtils.isAssignable(Acknowledgment.class, (Class)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        if (!message.getHeaders().containsKey((Object)this.acknowledgmentHeaderName) || message.getHeaders().get((Object)this.acknowledgmentHeaderName) == null) {
            throw new IllegalArgumentException("No acknowledgment object found for message header: '" + this.acknowledgmentHeaderName + "'");
        }
        return message.getHeaders().get((Object)this.acknowledgmentHeaderName);
    }
}

