/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.kinesis.integration;

import io.awspring.cloud.kinesis.integration.Checkpointer;
import java.math.BigInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.lang.Nullable;

class ShardCheckpointer
implements Checkpointer {
    private static final Log logger = LogFactory.getLog(ShardCheckpointer.class);
    private final ConcurrentMetadataStore checkpointStore;
    private final String key;
    private volatile String highestSequence;
    private volatile String lastCheckpointValue;
    private volatile boolean active = true;

    ShardCheckpointer(ConcurrentMetadataStore checkpointStore, String key) {
        this.checkpointStore = checkpointStore;
        this.key = key;
    }

    @Override
    public boolean checkpoint() {
        return this.checkpoint(this.highestSequence);
    }

    @Override
    public boolean checkpoint(String sequenceNumber) {
        if (this.active) {
            String existingSequence = this.getCheckpoint();
            if (existingSequence == null || new BigInteger(existingSequence).compareTo(new BigInteger(sequenceNumber)) < 0) {
                boolean stored;
                if (existingSequence != null) {
                    return this.checkpointStore.replace(this.key, existingSequence, sequenceNumber);
                }
                boolean bl = stored = this.checkpointStore.putIfAbsent(this.key, sequenceNumber) == null;
                if (stored) {
                    this.lastCheckpointValue = sequenceNumber;
                }
                return stored;
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("The [" + this + "] has been closed. Checkpoints aren't accepted anymore."));
        }
        return false;
    }

    void setHighestSequence(String highestSequence) {
        this.highestSequence = highestSequence;
    }

    @Nullable
    String getHighestSequence() {
        return this.highestSequence;
    }

    @Nullable
    String getCheckpoint() {
        this.lastCheckpointValue = this.checkpointStore.get(this.key);
        return this.lastCheckpointValue;
    }

    @Nullable
    String getLastCheckpointValue() {
        return this.lastCheckpointValue;
    }

    void remove() {
        this.checkpointStore.remove(this.key);
    }

    void close() {
        this.active = false;
    }

    public String toString() {
        return "ShardCheckpointer{key='" + this.key + "', lastCheckpointValue='" + this.lastCheckpointValue + "'}";
    }
}

