/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.kinesis.integration;

import com.amazonaws.services.schemaregistry.common.Schema;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.awspring.cloud.kinesis.integration.ConvertingFromMessageConverter;
import io.awspring.cloud.kinesis.integration.KplBackpressureException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.MutableMessage;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import software.amazon.kinesis.producer.KinesisProducer;
import software.amazon.kinesis.producer.UserRecord;
import software.amazon.kinesis.producer.UserRecordResult;

public class KplMessageHandler
extends AbstractMessageProducingHandler
implements Lifecycle {
    private static final long DEFAULT_SEND_TIMEOUT = 10000L;
    private final KinesisProducer kinesisProducer;
    private MessageConverter messageConverter = new ConvertingFromMessageConverter((Converter<Object, ?>)new SerializingConverter());
    private Expression streamExpression;
    private Expression partitionKeyExpression;
    private Expression explicitHashKeyExpression;
    private Expression glueSchemaExpression;
    private OutboundMessageMapper<byte[]> embeddedHeadersMapper;
    private Duration flushDuration = Duration.ofMillis(0L);
    private Expression sendTimeoutExpression = new ValueExpression((Object)10000L);
    private EvaluationContext evaluationContext;
    private volatile boolean running;
    private volatile ScheduledFuture<?> flushFuture;
    private long backPressureThreshold = 0L;

    public KplMessageHandler(KinesisProducer kinesisProducer) {
        Assert.notNull((Object)kinesisProducer, (String)"'kinesisProducer' must not be null.");
        this.kinesisProducer = kinesisProducer;
    }

    public void setBackPressureThreshold(long backPressureThreshold) {
        Assert.isTrue((backPressureThreshold >= 0L ? 1 : 0) != 0, (String)"'backPressureThreshold must be greater than or equal to 0.");
        this.backPressureThreshold = backPressureThreshold;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null.");
        this.messageConverter = messageConverter;
    }

    public void setStream(String stream) {
        this.setStreamExpression((Expression)new LiteralExpression(stream));
    }

    public void setStreamExpressionString(String streamExpression) {
        this.setStreamExpression(EXPRESSION_PARSER.parseExpression(streamExpression));
    }

    public void setStreamExpression(Expression streamExpression) {
        this.streamExpression = streamExpression;
    }

    public void setPartitionKey(String partitionKey) {
        this.setPartitionKeyExpression((Expression)new LiteralExpression(partitionKey));
    }

    public void setPartitionKeyExpressionString(String partitionKeyExpression) {
        this.setPartitionKeyExpression(EXPRESSION_PARSER.parseExpression(partitionKeyExpression));
    }

    public void setPartitionKeyExpression(Expression partitionKeyExpression) {
        this.partitionKeyExpression = partitionKeyExpression;
    }

    public void setExplicitHashKey(String explicitHashKey) {
        this.setExplicitHashKeyExpression((Expression)new LiteralExpression(explicitHashKey));
    }

    public void setExplicitHashKeyExpressionString(String explicitHashKeyExpression) {
        this.setExplicitHashKeyExpression(EXPRESSION_PARSER.parseExpression(explicitHashKeyExpression));
    }

    public void setExplicitHashKeyExpression(Expression explicitHashKeyExpression) {
        this.explicitHashKeyExpression = explicitHashKeyExpression;
    }

    public void setEmbeddedHeadersMapper(OutboundMessageMapper<byte[]> embeddedHeadersMapper) {
        this.embeddedHeadersMapper = embeddedHeadersMapper;
    }

    public void setFlushDuration(Duration flushDuration) {
        Assert.notNull((Object)flushDuration, (String)"'flushDuration' must not be null.");
        this.flushDuration = flushDuration;
    }

    public void setGlueSchema(Schema glueSchema) {
        this.setGlueSchemaExpression((Expression)new ValueExpression((Object)glueSchema));
    }

    public void setGlueSchemaExpressionString(String glueSchemaExpression) {
        this.setGlueSchemaExpression(EXPRESSION_PARSER.parseExpression(glueSchemaExpression));
    }

    public void setGlueSchemaExpression(Expression glueSchemaExpression) {
        this.glueSchemaExpression = glueSchemaExpression;
    }

    public void setSendTimeout(long sendTimeout) {
        this.setSendTimeoutExpression((Expression)new ValueExpression((Object)sendTimeout));
    }

    public void setSendTimeoutExpressionString(String sendTimeoutExpression) {
        this.setSendTimeoutExpression(EXPRESSION_PARSER.parseExpression(sendTimeoutExpression));
    }

    public void setSendTimeoutExpression(Expression sendTimeoutExpression) {
        Assert.notNull((Object)sendTimeoutExpression, (String)"'sendTimeoutExpression' must not be null");
        this.sendTimeoutExpression = sendTimeoutExpression;
    }

    protected void onInit() {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    public synchronized void start() {
        if (!this.running) {
            if (this.flushDuration.toMillis() > 0L) {
                this.flushFuture = this.getTaskScheduler().scheduleAtFixedRate(() -> ((KinesisProducer)this.kinesisProducer).flush(), this.flushDuration);
            }
            this.running = true;
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.running = false;
            if (this.flushFuture != null) {
                this.flushFuture.cancel(true);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void handleMessageInternal(Message<?> message) {
        UserRecord request = this.messageToUserRecord(message);
        CompletionStage resultFuture = this.handleMessageToAws(request).handle((response, ex) -> this.handleResponse(message, (UserRecordResult)response, (Throwable)ex));
        if (this.isAsync()) {
            this.sendOutputs(resultFuture, message);
            return;
        }
        Long sendTimeout = (Long)this.sendTimeoutExpression.getValue(this.evaluationContext, message, Long.class);
        try {
            if (sendTimeout == null || sendTimeout < 0L) {
                ((CompletableFuture)resultFuture).get();
            } else {
                ((CompletableFuture)resultFuture).get(sendTimeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (TimeoutException te) {
            throw new MessageTimeoutException(message, "Timeout waiting for response from KinesisProducer", (Throwable)te);
        }
        catch (InterruptedException ex2) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex2);
        }
        catch (ExecutionException ex3) {
            throw new IllegalStateException(ex3);
        }
    }

    private UserRecord messageToUserRecord(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof UserRecord) {
            UserRecord userRecord = (UserRecord)payload;
            return userRecord;
        }
        return this.buildUserRecord(message);
    }

    private UserRecord buildUserRecord(Message<?> message) {
        Object payload = message.getPayload();
        MessageHeaders messageHeaders = message.getHeaders();
        String stream = (String)messageHeaders.get((Object)"Kinesis_stream", String.class);
        if (!StringUtils.hasText((String)stream) && this.streamExpression != null) {
            stream = (String)this.streamExpression.getValue(this.evaluationContext, message, String.class);
        }
        Assert.state((stream != null ? 1 : 0) != 0, (String)"'stream' must not be null for sending a Kinesis record. Consider configuring this handler with a 'stream'( or 'streamExpression') or supply an 'aws_stream' message header.");
        String partitionKey = (String)messageHeaders.get((Object)"Kinesis_partitionKey", String.class);
        if (!StringUtils.hasText((String)partitionKey) && this.partitionKeyExpression != null) {
            partitionKey = (String)this.partitionKeyExpression.getValue(this.evaluationContext, message, String.class);
        }
        Assert.state((partitionKey != null ? 1 : 0) != 0, (String)"'partitionKey' must not be null for sending a Kinesis record.Consider configuring this handler with a 'partitionKey'( or 'partitionKeyExpression') or supply an 'aws_partitionKey' message header.");
        String explicitHashKey = this.explicitHashKeyExpression != null ? (String)this.explicitHashKeyExpression.getValue(this.evaluationContext, message, String.class) : null;
        Schema schema = this.glueSchemaExpression != null ? (Schema)this.glueSchemaExpression.getValue(this.evaluationContext, message, Schema.class) : null;
        MutableMessage messageToEmbed = null;
        ByteBuffer data = null;
        if (payload instanceof ByteBuffer) {
            ByteBuffer byteBuffer;
            data = byteBuffer = (ByteBuffer)payload;
            if (this.embeddedHeadersMapper != null) {
                messageToEmbed = new MutableMessage((Object)data.array(), (Map)messageHeaders);
            }
        } else {
            byte[] bytes = (byte[])(payload instanceof byte[] ? payload : this.messageConverter.fromMessage(message, byte[].class));
            Assert.notNull((Object)bytes, (String)"payload cannot be null");
            if (this.embeddedHeadersMapper != null) {
                messageToEmbed = new MutableMessage((Object)bytes, (Map)messageHeaders);
            } else {
                data = ByteBuffer.wrap(bytes);
            }
        }
        if (messageToEmbed != null) {
            try {
                byte[] bytes = (byte[])this.embeddedHeadersMapper.fromMessage((Message)messageToEmbed);
                Assert.notNull((Object)bytes, (String)"payload cannot be null");
                data = ByteBuffer.wrap(bytes);
            }
            catch (Exception ex) {
                throw new MessageConversionException(message, "Cannot embedded headers to payload", (Throwable)ex);
            }
        }
        return new UserRecord().withStreamName(stream).withPartitionKey(partitionKey).withExplicitHashKey(explicitHashKey).withData(data).withSchema(schema);
    }

    private CompletableFuture<UserRecordResult> handleMessageToAws(UserRecord userRecord) {
        try {
            CompletableFuture<UserRecordResult> completableFuture = this.handleUserRecord(userRecord);
            return completableFuture;
        }
        finally {
            if (this.flushDuration.toMillis() <= 0L) {
                this.kinesisProducer.flush();
            }
        }
    }

    private CompletableFuture<UserRecordResult> handleUserRecord(UserRecord userRecord) {
        int numberOfRecordsInFlight;
        if (this.backPressureThreshold > 0L && (long)(numberOfRecordsInFlight = this.kinesisProducer.getOutstandingRecordsCount()) > this.backPressureThreshold) {
            throw new KplBackpressureException("Cannot send record to Kinesis since buffer is at max capacity.", userRecord);
        }
        return KplMessageHandler.listenableFutureToCompletableFuture(this.kinesisProducer.addUserRecord(userRecord));
    }

    private Message<?> handleResponse(Message<?> message, UserRecordResult response, Throwable cause) {
        if (cause != null) {
            throw new MessageHandlingException(message, cause);
        }
        return this.getMessageBuilderFactory().fromMessage(message).copyHeadersIfAbsent(KplMessageHandler.additionalOnSuccessHeaders(response)).build();
    }

    private static Map<String, ?> additionalOnSuccessHeaders(UserRecordResult response) {
        return Map.of("Kinesis_shard", response.getShardId(), "Kinesis_sequenceNumber", response.getSequenceNumber());
    }

    private static <T> CompletableFuture<T> listenableFutureToCompletableFuture(final ListenableFuture<T> listenableFuture) {
        final CompletableFuture completable = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean result = listenableFuture.cancel(mayInterruptIfRunning);
                super.cancel(mayInterruptIfRunning);
                return result;
            }
        };
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                completable.complete(result);
            }

            public void onFailure(Throwable ex) {
                completable.completeExceptionally(ex);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return completable;
    }
}

